package com.zjty.tynotes.job;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author LJJ
 * on 2019-04-11
 */
@SpringBootApplication
@ComponentScan(basePackages = {
        "com.zjty.tynotes.misc",
        "com.zjty.tynotes.pas",
        "com.zjty.tynotes.job",
        "com.zjty.tynotes.search",
        "com.zjty.tynotes.redis",
        "com.zjty.tynotes.sms"
        ,"com.zjty.tynotes.log",
        "com.zjty.tynotes.address"
})
@EnableCaching
@EnableScheduling
public class JobApplication {
    public static void main(String[] args) {
        SpringApplication.run(JobApplication.class, args);
    }
}
