package com.zjty.tynotes.job.basic.service.impl;

import com.zjty.tynotes.address.server.dao.NoticeDao;
import com.zjty.tynotes.address.server.entity.Notice;
import com.zjty.tynotes.address.server.service.NoticeService;
import com.zjty.tynotes.job.basic.entity.database.Attachment;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.response.WorkOverTime;
import com.zjty.tynotes.job.basic.entity.response.WorkVo;
import com.zjty.tynotes.job.basic.repository.AttachmentRepository;
import com.zjty.tynotes.job.basic.service.AttachmentService;
import com.zjty.tynotes.job.basic.service.ConversionService;
import com.zjty.tynotes.job.basic.service.PriviceService;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class ConversionServiceImpl implements ConversionService {
    @Autowired
    IUserService iUserService;

    @Autowired
    AttachmentRepository attachmentRepository;
    @Autowired
    PriviceService priviceService;
    @Autowired
    private NoticeDao noticeDao;
    @Override
    public WorkVo workToVo(Work work) {
        log.info("开始转换对象");
        User pUser=iUserService.findUserById(work.getPublisher());

        User eUser=iUserService.findUserById(work.getExecutor());
        User aUser=iUserService.findUserById(work.getAudit());
        List<User> users=new ArrayList<>();
        List<String> uid=work.getCrewList();
        List<Attachment> attachments=new ArrayList<>();
        List<String> attachIds=work.getAttachment();
      List<Notice> list= noticeDao.findAllByWorkId(work.getId());
        list.forEach(i->{
            if (i.getIsAgree()==null || i.getIsAgree().equals("1")){
                uid.remove(i.getBorrowUserId());
            }
        });
        if (uid!=null && uid.size()!=0){
            for (String id:uid){
                users.add(iUserService.findUserById(id));
            }
        }
        if (users.size()==0){
            users=null;
        }

        if (attachIds!=null && attachIds.size()!=0){
            for (String id:attachIds){
                attachments.add(attachmentRepository.findById(id).get());
            }
        }


        if (work.getSuperiorId()==null || "".equals(work.getSuperiorId())){
            return new WorkVo(
                    work.getId(),
                    work.getSuperiorId(),
                    work.getTitle(),
                    work.getCreateTime(),
                    work.getStateTime(),
                    work.getEndTime(),
                    work.getCompleteTime(),
                    work.getUpdateTime(),
                    work.getSubmitTime(),
                    work.getAuditTime(),
                    pUser,
                    eUser,
                    users,
                    attachments,
                    work.getContent(),
                    work.getWorkload(),
                    work.getStatus(),
                    work.getWorkCoefficient(),
                    work.getPWorkload(),
                    work.getWorkloadCount(),
                    aUser,
                    selectUserIdAll(work.getMajordomos()),
                    selectUserIdAll(work.getGeneralManagers()),
                    selectUserIdAll(work.getAssistantManagers())
            );
        }else {
            return new WorkVo(
                    work.getId(),
                    work.getSuperiorId(),
                    work.getTitle(),
                    work.getCreateTime(),
                    work.getStateTime(),
                    work.getEndTime(),
                    work.getCompleteTime(),
                    work.getUpdateTime(),
                    work.getSubmitTime(),
                    work.getAuditTime(),
                    pUser,
                    eUser,
                    users,
                    attachments,
                    work.getContent(),
                    work.getWorkload(),
                    work.getStatus(),
                    work.getWorkCoefficient(),
                    work.getPWorkload(),
                    work.getWorkloadCount(),
                    aUser,
                    selectUserIdAll(work.getMajordomos()),
                    selectUserIdAll(work.getGeneralManagers()),
                    selectUserIdAll(work.getAssistantManagers()));
        }

    }

    @Override
    public WorkOverTime workToWorkOverTime(Work work) {
        List<User> users=new ArrayList<>();
        work.getCrewList().forEach(id->{
            users.add(iUserService.findUserById(id));
        });

        return new WorkOverTime(work.getId(),work.getTitle(),users);
    }

    private List<User> selectUserIdAll(List<String> list){
        return  iUserService.findUserByIds(list);
    }

}
