package com.zjty.tynotes.log.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/4/23 15:56
 */
@ApiModel(value = "日志请求分页类", description = "日志请求分页类")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LogPageRequest {
    /**
     * 每页显示个数
     */
    @ApiModelProperty(value = "每页数据数量",example = "10")
    private int pageSize;
    /**
     * 当前页数
     */
    @ApiModelProperty(value = "当前页",example = "1")
    private int currentPage;
    /**
     * 总记录数
     */
    @ApiModelProperty(value = "总记录数",example = "10")
    private int totalCount;

    /**
     * 起始时间
     */
    @ApiModelProperty(value = "起始时间",example = "2020-04-01 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间",example = "2020-04-01 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;
}
