package com.zjty.tynotes.weekly.subject.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import com.zjty.tynotes.weekly.subject.entity.vo.Problem;
import com.zjty.tynotes.weekly.subject.entity.vo.UserVo;
import com.zjty.tynotes.weekly.subject.service.UserManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import java.text.ParseException;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/3/2 13:04
 */
@Api(tags = "人员管理模块", protocols = "http")
@RestController
@RequestMapping("/manage/user")
@AutoDocument
public class UserManageController {
    @Autowired
    private UserManageService userManageService;

    private static final Logger logger = LoggerFactory.getLogger(UserManageController.class);


    @ApiOperation(value = "根据id查询用户", response = User.class)
    @GetMapping("/findUser/{id}")
    public ResponseEntity findUser(@RequestBody @Valid String id) {
        return ok(userManageService.findUserById(id));
    }

    //待完成
    @ApiOperation(value = "查询人员列表", response = User.class)
    @PostMapping("/findUserList")
    public ResponseEntity findUserList(@RequestBody PageRequest pageRequest) {
        PageResponse<UserVo> userList = null;
        try {
            userList = userManageService.findUserList(pageRequest);
            return ok(userList);
        } catch (ParseException e) {
            e.printStackTrace();
            logger.error("查询人员列表失败:{}",e.getMessage());
        }
        return ok("查询人员列表失败");
    }

    @ApiOperation(value = "根据权限查询可查看部门列表", response = User.class)
    @GetMapping("/findDepartmentList/{id}")
    public ResponseEntity findDepartmentList(@PathVariable("id") String id) {
        return ok(userManageService.findDepartmentList(id));
    }

//    @ApiOperation(value = "查询人员任务详情", response = User.class)
//    @GetMapping("/findUserWork/{id}/{status}")
//    public ResponseEntity findUserWork(@PathVariable("id") String id,
//                                             @PathVariable("status") String status) {
//        return ok(userManageService.findUserWork(id,status));
//    }

    @ApiOperation(value = "更新当前用户自身信息")
    @PutMapping("/updateSelf")
    public ResponseEntity updateSelf(@RequestBody @NotNull User user){
        try {
            User userById = userManageService.findUserById(user.getId());
            User user1 = userManageService.updateSelf(user, userById);
            return ok(user1);
        } catch (Exception e) {
            logger.error("更改当前用户自身信息失败");
        }
        return ok("更改当前用户信息失败");
    }

    @ApiOperation(value = "更新当前用户密码")
    @PutMapping("/password")
    public ResponseEntity updatePassword(@RequestBody @NotNull User user){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User principal = (User) authentication.getPrincipal();
        User userByUsername = userManageService.findfindUserByUsername(principal.getUsername());
        userByUsername.setPassword(user.getPassword());
        boolean b = userManageService.updatePas(userByUsername);
        if(b){
            return ok("更改密码成功");
        }
        return ok("更改密码失败");
    }

    @ApiOperation(value = "上传建议以及使用中的问题")
    @PostMapping
    public ResponseEntity submitProblem(@RequestBody Problem problem){
        return ok(userManageService.submitProblem(problem));
    }

    @ApiOperation(value = "查找建议以及使用中的问题")
    @GetMapping
    public ResponseEntity searchProblem(){
        return ok(userManageService.searchProblem());
    }

    @ApiOperation(value = "修改建议以及使用中的问题")
    @PutMapping
    public ResponseEntity putProblem(@RequestBody Problem problem){
        return ok(userManageService.putProblem(problem));
    }


}
