package com.zjty.tynotes.attendance.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/24 15:03
 * @des 审批信息表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "审批信息", description = "审批信息")
@Document(collection = "ding_appro")
public class ApprovalInformation {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @ApiModelProperty(value = "审批名称",example = "1")
    private String title;

    @ApiModelProperty(value = "提交审批用户id",example = "1")
    private String userId;

    @ApiModelProperty(value = "提交审批用户姓名",example = "1")
    private String userName;

    @ApiModelProperty(value = "审批用户id1",example = "1")
    private String approvalUserIdOne;

    @ApiModelProperty(value = "审批用户1名字",example = "张三")
    private String approvalUserIdOneName;

    @ApiModelProperty(value = "审批用户id2",example = "1")
    private String approvalUserIdTwo;

    @ApiModelProperty(value = "审批用户2名字",example = "李四")
    private String approvalUserIdTwoName;

    @ApiModelProperty(value = "审批类型,事假/调休/病假/公出/出差",example = "事假/调休/病假/公出/出差")
    private String approvalType;

    @ApiModelProperty(value = "审批状态,0代表待审批，1代表已通过，2代表已拒绝",example = "0/1/2")
    private String status;

    @ApiModelProperty(value = "审批描述",example = "...")
    private String description;

    @ApiModelProperty(value = "审批不通过原因",example = "请假过多，不予请假")
    private String reason;

    @ApiModelProperty(value = "审批等级,一级审批还是二级审批",example = "1")
    private String approvalLevel;

    @ApiModelProperty(value = "请假开始时间",example = "2020-03-20 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date leaveStartTime;

    @ApiModelProperty(value = "请假结束时间",example = "2020-03-21 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date leaveEndTime;

    @ApiModelProperty(value = "一级审批是否通过",example = "0/1")
    private String approvalOne;

    @ApiModelProperty(value = "二级审批是否通过",example = "0/1")
    private String approvalTwo;

    @ApiModelProperty(value = "当前审批是否通过,0代表通过，1代表未通过",example = "0")
    private String approvalStatus;

    @ApiModelProperty(value = "当前用户所选择的审批部门id",example = "12dqweqe122")
    private String departmentId;

    @ApiModelProperty(value = "申请时间",example = "2020-04-03 09:00:00")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    @ApiModelProperty(value = "天数",example = "2")
    private Float numberDay;
}
