package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.base.advise.Content;
import com.zjty.tynotes.pas.entity.Authority;
import com.zjty.tynotes.pas.entity.Role;
import com.zjty.tynotes.pas.service.IRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * @author mcj
 */
@Api(tags = "用户管理权限管理模块",protocols = "http")
@RestController
@RequestMapping("/pas/role")
@AutoDocument
public class RoleController {

    @Autowired
    private IRoleService iRoleService;

    @ApiOperation(value = "获得所有角色",response = Role.class)
    @GetMapping
    public ResponseEntity roles(){
        return ResponseEntity.ok(iRoleService.findAll());
    }

    @Content(value = "新增角色")
    @ApiOperation(value = "新增角色",response = Role.class)
    @PostMapping
    public ResponseEntity addRole(@RequestBody @Valid Role role){
        return ResponseEntity.ok(iRoleService.addRole(role));
    }


//    @ApiOperation(value = "添加角色",response = Role.class)
//    @PostMapping
//    public ResponseEntity addRole(@RequestBody @Valid List<Role> role){
//        return ResponseEntity.ok(iRoleService.addRole(role));
//    }

    @Content(value = "删除角色")
    @ApiOperation(value = "删除角色",response = Role.class)
    @DeleteMapping("/deleteRole/{id}")
    public String deleteRole(@PathVariable("id") String id){
        try {
            boolean b = iRoleService.deleteRole(id);
            if(b){
                return "删除成功";
            }
        } catch (Exception e) {

        }
        return "删除失败";
    }

    @Content(value = "修改角色")
    @ApiOperation(value = "修改角色",response = Role.class)
    @PutMapping("/updateRole")
    public String updateRole(@RequestBody Role role){
        try {
            Boolean b = iRoleService.updateRole(role);
            if(b){
                return "修改角色成功";
            }
        } catch (Exception e) {
            return "修改角色失败";
        }
        return "修改角色失败";
    }

    @ApiOperation(value = "根据部门查询角色",response = Role.class)
    @GetMapping("/findRoleByDepartId/{id}")
    public ResponseEntity updateRole(@PathVariable("id") String id){

        return ResponseEntity.ok(iRoleService.findRoleByDepartId(id));
    }







}
