package com.zjty.tynotes.job.status.entity;

import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "任务列表对象")
public class RedisPersonalWork {

    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id",name = "workId",example = "3y8735217537c")
    private String workId;

    /**
     * 时间 秒
     */

    @ApiModelProperty(value = "时间",name = "time",example = "7878979686L")
    private Long time;
    /**
     *任务标题
     */
    @ApiModelProperty(value = "任务标题",name = "title",example = "xxx")
    private String title;
    /**
     * 任务状态
     */
    @ApiModelProperty(value = "任务状态",name = "status",example = "进行中")
    private String status;
    /**
     * 发布者
     */
    @ApiModelProperty(value = "发布者",name = "release",example = "xx")
    private String release;
    /**
     * 执行者
     */
    @ApiModelProperty(value = "执行者",name = "executor",example = "xxx")
    private String executor;

    /**
     * 已读未读
     */
    @ApiModelProperty(value = "是否已读（0已读,1未读）",name = "readState",example = "1")
    private int readState;

    /**
     * 任务所属位置 我的任务 我接受的任务
     */
    @ApiModelProperty(value = "任务所属位置",name = "workAttribution",example = "1")
    private int workAttribution;

    /**
     * 最近的操作
     */
    @ApiModelProperty(value = "最近一次的操作",name = "latestNews",example = "root留言")
    private String latestNews;

    /**
     * 上级任务id
     */
    @ApiModelProperty(value = "上级任务id",name = "superiorId",example = "root留言")
    private String superiorId;

    /**
     * 子任务id集合
     */
    @ApiModelProperty(value = "上级任务id",name = "superiorId",example = "root留言")
    private List<String> subtaskIds;
}
