package com.zjty.tynotes.pas.controller;

import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.Authority;
import com.zjty.tynotes.pas.service.IAuthorityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @author mcj
 */
@Api(tags = "用户管理权限管理模块",protocols = "http")
@RestController
@RequestMapping("/pas/authority")
@AutoDocument
public class AuthorityController {

    @Autowired
    private IAuthorityService iAuthorityService;

    @ApiOperation("新增权限")
    @PostMapping("/addAuthority")
    public ResponseEntity addAuthority(@RequestBody Authority authority){
        return ok(iAuthorityService.addAuthority(authority));
    }

    @ApiOperation("删除权限")
    @DeleteMapping("/deleteAuthority/{id}")
    public String deleteAuthority(@PathVariable("id") String id){
        try {
            boolean b = iAuthorityService.deleteAuthority(id);
            if(b){
                return "删除成功";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "删除失败";
    }

    @ApiOperation("修改权限")
    @PutMapping("/updateAuthority")
    public String updateAuthority(@RequestBody Authority authority){
        try {
            Authority authority1 = iAuthorityService.updateAuthority(authority);
            if(authority1!=null){
                return "修改权限成功";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "修改权限失败";
    }

    @ApiOperation("查询所有权限")
    @GetMapping("/findAuthority")
    public ResponseEntity findAuthority(){
        return ok(iAuthorityService.findAuthority());
    }



}
