package com.zjty.tynotes.pas.service;

import com.zjty.tynotes.pas.entity.Role;

import java.util.List;

/**
 * @author mcj
 */
public interface IRoleService {
    /**
     * 根据角色id查询角色对象
     * @param id id
     * @return Role对象
     */
    Role findRoleById(String id);

    /**
     * 查询所有角色
     * @return list
     */
    List<Role> findAll();

    /**
     * 添加角色
     * @param role 角色对象
     * @return Role
     */
    Role addRole(Role role);


    /**
     * 删除所有角色
     */
    void deleteAll();

    /**
     * 修改角色
     * @param role
     * @return
     */
    Boolean updateRole(Role role);

    /**
     * 删除角色
     * @param id
     * @return
     */
    boolean deleteRole(String id);
}
