package com.zjty.tynotes.job.basic.controller;

import com.zjty.tynotes.job.basic.entity.database.Attachment;
import com.zjty.tynotes.job.basic.entity.response.JobResponse;
import com.zjty.tynotes.job.basic.service.AttachmentService;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * <p>Description : ty-note-backend
 * <p>Date : 2019/5/5 10:08
 * <p>@author : C
 */
@AutoDocument
@Api(tags = "工作记录相关接口", description = "工作记录模块")
@RestController
@RequestMapping("/job/attachment")
public class AttachmentController {

    private final
    AttachmentService attachmentService;

    @Autowired
    public AttachmentController(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    @PostMapping("/{workId}")
    @ApiOperation(value = "新增附件结合并将其添加到所属工作中.", notes = "新增不可在数据中附带id.需要在路径中指定所属工作的id.成功时返回新增数据保存的id.")
    public ResponseEntity<JobResponse> add(@RequestBody List<Attachment> attachment, @PathVariable String workId) {
        String saveId = attachmentService.add(attachment, workId);
        return ok(new JobResponse(saveId));
    }

    @PostMapping("/one/{workId}")
    @ApiOperation(value = "新增附件并将其添加到所属工作中.", notes = "新增不可在数据中附带id.需要在路径中指定所属工作的id.成功时返回新增数据保存的id.")
    public ResponseEntity<JobResponse> add(@RequestBody Attachment attachment) {
        String saveId = attachmentService.add(attachment);
        return ok(new JobResponse(saveId));
    }

    @PutMapping()
    @ApiOperation(value = "修改附件.", notes = "修改必须在数据中附带id.")
    public ResponseEntity<JobResponse> modify(@RequestBody Attachment attachment) {
        String saveId = attachmentService.modify(attachment);
        return ok(new JobResponse(saveId));
    }

    @DeleteMapping("/{attachmentId}")
    @ApiOperation(value = "根据id删除附件.")
    public ResponseEntity<JobResponse> delete(@PathVariable String attachmentId) {
        return ok(new JobResponse());
    }
}
