package com.zjty.tynotes.pas.service;

import com.zjty.tynotes.pas.entity.Department;

import java.util.List;

/**
 * @author mcj
 */
public interface IDepartmentService {

    /**
     * 查询所有部门
     * @return List
     */
    List<Department> findAll();

    /**
     * 添加部门列表
     * @param department 部门列表
     * @return 添加的部门
     */
    Department addDepartments(Department department);

    /**
     * 删除所有部门
     */
    void deleteAll();

    /**
     * 根据id查找部门
     * @param id 部门id
     * @return 部门详情
     */
    Department findOne(String id);

    /**
     * 查找所有部门列表
     * @return
     */
    List<Department> findList();

}
