package com.zjty.tynotes.attendance.service;

import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.entity.WorkoverAppro;
import com.zjty.tynotes.attendance.entity.vo.request.PageRequest;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.vo.PageResponse;

import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 15:23
 * @des 提交审批业务处理
 */
public interface ApprovalInformationService {
    /**
     * 提交审批
     * @param approvalInformation
     * @return
     */
    ApprovalInformation addApproval(ApprovalInformation approvalInformation);

    /**
     * 删除审批
     * @param id
     */
    boolean deleteApproval(String id);

    /**
     * 审核审批
     * @param userId
     * @param status
     * @return
     */
    ApprovalInformation auditApproval(String userId,String status,ApprovalInformation approvalInformation);

    /**
     * 查询所有用户自身提交的审批
     * @param pageRequest
     * @return
     */
    PageResponse<ApprovalInformation> findAllApproval(PageRequest pageRequest);

    /**
     * 查找所有我审核的审批
     * @param pageRequest
     * @return
     */
    PageResponse<ApprovalInformation> findAllAuditApproval(PageRequest pageRequest);

    /**
     * 提交加班申请单
     * @param workoverAppro
     * @return
     */
    WorkoverAppro addWorkoverApproval(WorkoverAppro workoverAppro);

    /**
     * 审批加班申请单流程
     * @param workoverAppro
     * @param userId
     * @param status
     * @return
     */
    WorkoverAppro approWorkover(WorkoverAppro workoverAppro, String userId, String status);


    /**
     * 查找所有自己提交的加班审批
     * @param pageRequest
     * @return
     */
    PageResponse<WorkoverAppro> findAllSubmitWorkOverApproval(PageRequest pageRequest);

    /**
     * 查找所有审核的加班审批
     * @param pageRequest
     * @return
     */
    PageResponse<WorkoverAppro> findAllAuditWorkOverApproval(PageRequest pageRequest);

    /**
     * 查询申请单可选择的部门
     * @return
     */
    List<Department> findSelectDepartment();

}
