package com.zjty.tynotes.job.basic.service.impl;

import com.google.common.collect.Lists;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.response.WorkIsNotCommit;
import com.zjty.tynotes.job.basic.entity.response.WorkVo;
import com.zjty.tynotes.job.basic.repository.WorkRepository;
import com.zjty.tynotes.job.basic.service.ConversionService;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.basic.utils.WorkingTime;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.common.exception.BadRequestException;
import com.zjty.tynotes.job.common.exception.NotFoundException;
import com.zjty.tynotes.pas.entity.vo.HolidayRequest;
import com.zjty.tynotes.pas.service.ConfigService;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.pas.service.impl.UserServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import static java.util.Objects.isNull;
import static java.util.Objects.nonNull;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 11:32
 * <p>@author : C
 * 接口定义说明见↓
 *
 * @see WorkService
 */
@Slf4j
@Service
public class WorkServiceImpl implements WorkService {

    private final
    WorkRepository workRepository;

    @Autowired
    IUserService iUserService;

    @Autowired
    ConversionService conversionService;
    @Autowired
    public WorkServiceImpl(WorkRepository workRepository) {
        this.workRepository = workRepository;
    }
    @Autowired
    ConfigService configService;

    @Override
    public String add(Work work) {
        //新增数据不可附带id.
        Boolean idMustNull = isNull(work.getId());
        if (idMustNull) {
            work.setCreateTime(new Date());
            work.setUpdateTime(new Date());
            String saveId = workRepository.save(work).getId();
            log.info(String.format("[job]  新增了id为 %s 的数据.", saveId));
            return saveId;
        } else {
            String msg = "[job] %s: 新增数据不可附带id.";
            log.error(msg);
            throw new BadRequestException(msg);
        }
    }

    @Override
    public String modify(Work work) {
        //更新数据必须指定id且指定id的数据存在.
        Boolean idMustExist = (nonNull(work.getId())) && (workRepository.existsById(work.getId()));
        if (idMustExist) {
            String modifyId = workRepository.save(work).getId();
            log.info(String.format("[job] 更新了id为 %s 的数据.", modifyId));
            return modifyId;
        } else {
            String msg = "[job] 更新数据必须指定id且指定id的数据存在.";
            log.error(msg);
            throw new BadRequestException(msg);
        }
    }

    @Override
    public List<Work> findAll() {
        return workRepository.findAll();
    }

    @Override
    public List<Work> findAll(List<String> ids) {
        return Lists.newArrayList(workRepository.findAllById(ids));
    }

    @Override
    public Boolean idExists(String workId) {
        return workRepository.existsById(workId);
    }

    @Override
    public Work findById(String workId) {
        Optional<Work> workOptional = workRepository.findById(workId);
        return workOptional.orElseThrow(() -> new BadRequestException(String.format("[job] id为 %s 的数据不存在.", workId)));
    }

    @Override
    public void delete(String workId) {
        if (workRepository.existsById(workId)) {
            workRepository.deleteById(workId);
        } else {
            throw new NotFoundException(String.format("[job] id为 %s 的工作不存在.", workId));
        }
    }

    @Override
    public void deleteAll() {
    }

    @Override
    public void alterTaskStatus(String taskId, String status) {
        Work ob = workRepository.findById(taskId).get();

        ob.setStatus(status);
        if (status.equals(WorkStatus.ONGOING)){
            Float expect= score(ob.getStateTime(),ob.getCompleteTime());
            Float practical=score(ob.getStateTime(),ob.getEndTime());
          if (expect<practical){
              float time=  practical-expect;
               beyond(1,1.0f,time);
               //添加
          }else if (expect.equals(practical)){


              //添加
          }else {
              float time=  expect-practical;
              advance(1,1.0f,time);
          }

        }
        workRepository.save(ob);
    }
private float beyond(float count,float coefficient,Float time){
        if (coefficient<0.5f){
            return 0.5f;
        }
        float si=time-4;

        if (si<4){
            return coefficient-0.025f*count;
        }else {
            coefficient=coefficient-0.025f*count;
        }
        count++;
        return beyond(count,coefficient,si);
}

    private float advance(float count,float coefficient,Float time){
        if (coefficient>1.2f){
            return 1.2f;
        }
        float remainingTime=time-6;

        if (remainingTime<6){
            return coefficient+0.025f*count;
        }else {
            coefficient=coefficient +0.025f*count;
        }
        count++;
        return beyond(count,coefficient,remainingTime);
    }

private Float score(Date startTime,Date entTime){
   List<Date> dates= configService.findHolidays(new HolidayRequest(startTime,entTime));
    try {
       return WorkingTime.findOperHours(dates,startTime,entTime);
    } catch (ParseException e) {
        e.printStackTrace();
    }
return null;
}

    @Override
    public void deleteWork(String taskId, int personalWorkload, int workloadCount) {
        Work ob = workRepository.findById(taskId).get();
        ob.setPWorkload(personalWorkload);
        ob.setWorkloadCount(workloadCount);
        workRepository.save(ob);
    }

    @Override
    public void updateWorkCrew(String taskId, List<String> crews) {
        Work ob = workRepository.findById(taskId).get();
        ob.setCrewList(crews);
        workRepository.save(ob);
    }

    @Override
    public void updateWorkload(String taskId, int workload, int workCoefficient) {
        Work ob = workRepository.findById(taskId).get();
        ob.setWorkload(workload);
        ob.setWorkCoefficient(workCoefficient);
        workRepository.save(ob);
    }

    @Override
    public WorkIsNotCommit findBySuperoirId(String SuperoirId) {
        if (!workRepository.existsById(SuperoirId)){
            throw new NotFoundException(String.format("[job] id为 %s 的任务不存在.", SuperoirId));
        }
       List<Work> works= workRepository.findBySuperiorId(SuperoirId);
       List<String> list=new ArrayList<>();
       String isNotCommit="1";
       if (works!=null && works.size()!=0){
           for (Work work:works){
               if (!WorkStatus.FINISHED.equals(work.getStatus())){
                   isNotCommit="0";
                   list.add(work.getId());
               }
           }
           return new WorkIsNotCommit(isNotCommit,list);
       }else {
           return new WorkIsNotCommit(isNotCommit,list);
       }
    }

    @Override
    public int findBySuperoirIdCount(String SuperoirId) {
        if (!workRepository.existsById(SuperoirId)){
            throw new NotFoundException(String.format("[job] id为 %s 的任务不存在.", SuperoirId));
        }
        List<Work> works= workRepository.findBySuperiorId(SuperoirId);
        int count= workRepository.findById(SuperoirId).get().getWorkload();
        if (works!=null && works.size()!=0){
            for (Work work:works){
                if(work.getWorkloadCount()==1) {
                    count = count - work.getWorkload();
                }
            }
            return count;
        }else {
            return count;
        }

    }

    @Override
    public List<WorkVo> selectUserIdsWork(String userId) {


        return workRepository.findAllByExecutorIn(iUserService.findUsers(userId))
                .stream()
                .map(conversionService::workToVo)
                .collect(Collectors.toList());
    }

//    @Override
//    public List<Work> selectTimeWork() {
////        LocalDateTime minTime = LocalDateTime.now().with(LocalTime.MIN).atZone(ZoneOffset.ofHours(8)).ge;
//        workRepository.findByCompleteTimeGreaterThan(new Date());
//        return null;
//    }
}
