package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author gwj
 * @create 2020/5/13 11:20
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "打卡报警", description = "打卡报警信息")
@Document(collection = "card_alarm")
public class CardAlarm {
    @Id
    @ApiModelProperty(value = "打卡报警信息的id",example = "123qdsdd212")
    private String id;

    @ApiModelProperty(value = "用户id",example = "")
    private String userId;

    @ApiModelProperty(value = "报警描述",example = "使用虚拟定位打卡")
    private String des;

}
