package com.zjty.tynotes.pas.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author gwj
 * @create 2020/5/13 8:46
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "通讯录", description = "通讯录说明")
public class Address {

    @Excel(name = "序号")
    @ApiModelProperty(value = "序号",example = "gwj")
    private String id;

    @Excel(name = "姓名")
    @ApiModelProperty(value = "姓名",example = "gwj")
    private String name;

    @Excel(name = "性别")
    @ApiModelProperty(value = "性别",example = "男")
    private String sex;


    @Excel(name = "手机")
    @ApiModelProperty(value = "手机号",example = "13211111111")
    private String telphone;

    @Excel(name = "家庭住址")
    @ApiModelProperty(value = "家庭住址",example = "13211111111")
    private String homeAddress;

    @Excel(name = "身份证号码")
    @ApiModelProperty(value = "身份证号码",example = "330122200011111111")
    private String idCard;

    @Excel(name = "职务")
    @ApiModelProperty(value = "职务",example = "后端程序员")
    private String duty;

//    @Excel(name = "手机虚拟号")
//    @ApiModelProperty(value = "短号",example = "666666")
//    private String shortphone;

    @Excel(name = "工号")
    @ApiModelProperty(value = "工号",example = "1111111111111")
    private String workerNum;

    @ApiModelProperty(value = "邮箱",example = "hz")
    private String email;

    public Address(User user) {
        this.homeAddress = user.getAddress();
        this.idCard = user.getIdCard();
        this.workerNum = user.getWorkerNum();
        this.name = user.getUsername();
        this.duty = user.getJobs();
        this.telphone = user.getPhone1();
        this.sex = user.getSex();
//        this.shortphone = user.getPhone2();
        this.email = user.getEmail();
    }
}
