package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.service.WorkService;
import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.common.exception.WorkAttribution;
import com.zjty.tynotes.job.common.exception.WorkAttribution1;
import com.zjty.tynotes.job.status.entity.RedisPersonalWork;
import com.zjty.tynotes.job.status.entity.RoleSum1;
import com.zjty.tynotes.job.status.service.TestService;
import com.zjty.tynotes.job.status.utils.JacksonUtil;
import com.zjty.tynotes.pas.service.IUserService;
import com.zjty.tynotes.search.subject.entity.EsSource;
import com.zjty.tynotes.search.subject.service.EsUtil;
import com.zjty.tynotes.sms.service.MessageTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.CompletableFuture;

/**
 * 任务状态 我的代办任务、我的相关任务、我的发布任务、我的分解任务
 */
@Service
@Slf4j
public class TestServiceImpl implements TestService {
    @Autowired
    private RedisTemplate<String,Object> redisTemplate;

    @Autowired
    MessageTemplateService messageTemplateService;

    @Autowired
    WorkService workService;

    @Autowired
    EsUtil esUtil;

    @Autowired
    IUserService iUserService;


    private List<String> tests(String id,List<String> list){
        Work work=workService.findById(id);
        String workId=work.getSuperiorId();
        list.add(work.getPublisher());
        if (workId==null || "".equals(workId)){
            return list;
        }
        return tests(workId,list);
    }


    @Override
    public void saveTakePushWork(String executorId, String latestNews,  Work work) {
        List<String> uIds=new ArrayList<>();
        Long time=new Date().getTime();
        String releaseName= iUserService.findUserById(work.getPublisher()).getUsername();
        String executorName= iUserService.findUserById(work.getExecutor()).getUsername();
        RedisPersonalWork personalWork=new RedisPersonalWork(work.getId(),time,work.getTitle(),work.getStatus(),releaseName,executorName,1,WorkAttribution.ME_WORK,latestNews,work.getSuperiorId(),new ArrayList<>(),0,0);
        if (releaseName.equals(executorName)){
            if (work.getSuperiorId() == null){
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELEASE_WORK);
                personalWork.setExecutorEqualRelease(1);
                personalWork.setReadState(0);
                personalWork.setIsNotCommission(1);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

            }else {
                uIds = tests(work.getSuperiorId(), uIds);
                personalWork.setWorkAttribution(WorkAttribution1.ME_RESOLVE_WORK);
                personalWork.setExecutorEqualRelease(1);
                personalWork.setReadState(0);
                personalWork.setIsNotCommission(1);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

            }

        }else {
            //发布人
            if (work.getSuperiorId() == null) {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELEASE_WORK);
                personalWork.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

            } else {
                uIds = tests(work.getSuperiorId(), uIds);
                personalWork.setWorkAttribution(WorkAttribution1.ME_RESOLVE_WORK);
                personalWork.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                subWork(list, work, work.getPublisher());
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            }
            //执行人 判断执行人是否有分解权限

            personalWork.setWorkAttribution(WorkAttribution1.ME_RECEIVE_WORK);
            personalWork.setReadState(1);
            personalWork.setIsNotCommission(1);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getExecutor(), personalWork);

            asynchronousAddEs(Constants.REDIS_EVENT + work.getExecutor(), personalWork);
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getExecutor(), 0, -1);
            assert list != null;
            pushData(work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            subWork(list, work, work.getExecutor());
            log.info("{}这里发送{}", work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));

        }
        //有待修改
        if (uIds.size()!=0) {
            for (String id : uIds) {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELATED_WORK);
                personalWork.setReadState(1);
                personalWork.setIsNotCommission(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + id, personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + id, personalWork);
              List<Object>  list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
                assert list != null;
                pushData(id, JacksonUtil.toJSon(statisticalRoleCount(list)));
                subWork(list, work, id);
                log.info("{}这里发送{}", id, JacksonUtil.toJSon(statisticalRoleCount(list)));
            }
        }
    }


    @Override
    public void saveWork(String executorId, String latestNews, Work work) {
        Long time=new Date().getTime();

        String releaseName= iUserService.findUserById(work.getPublisher()).getUsername();
        String executorName= iUserService.findUserById(work.getExecutor()).getUsername();
        RedisPersonalWork personalWork=new RedisPersonalWork(work.getId(),time,work.getTitle(),work.getStatus(),releaseName,executorName,1,WorkAttribution.ME_WORK,latestNews,work.getSuperiorId(),new ArrayList<>(),0,0);
        if (releaseName.equals(executorName)){
            if (work.getSuperiorId() == null){
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELEASE_WORK);
                personalWork.setExecutorEqualRelease(1);
                personalWork.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

            }else {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RESOLVE_WORK);
                personalWork.setExecutorEqualRelease(1);
                personalWork.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

            }
        }else {

            //发布人
            if (work.getSuperiorId() == null) {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RELEASE_WORK);
                personalWork.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

            } else {
                personalWork.setWorkAttribution(WorkAttribution1.ME_RESOLVE_WORK);
                personalWork.setReadState(0);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), personalWork);

                asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
                assert list != null;
                pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
                subWork(list, work, work.getPublisher());
                log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            }
        }
    }

    @Override
    public void unpublishedToOngoing(String executorId, String latestNews,  Work work) {
        Long time=new Date().getTime();
        List<String> uIds=new ArrayList<>();
        if (work.getSuperiorId()!=null) {
            uIds = tests(work.getSuperiorId(), uIds);
        }
        String releaseName= iUserService.findUserById(work.getPublisher()).getUsername();
        String executorName= iUserService.findUserById(work.getExecutor()).getUsername();
        RedisPersonalWork personalWork=new RedisPersonalWork(work.getId(),time,work.getTitle(),work.getStatus(),releaseName,executorName,1,WorkAttribution.ME_WORK,latestNews,work.getSuperiorId(),new ArrayList<>(),0,0);
        if (releaseName.equals(executorName)){
            List<Object> objects = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : objects) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (work.getId().equals(redisPersonalWork.getWorkId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    redisPersonalWork.setStatus(work.getStatus());
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setIsNotCommission(1);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(objects)));
            subWork(objects, work, work.getPublisher());
            log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(objects)));
        }else {
            //发布人
            List<Object> objects = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : objects) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (work.getId().equals(redisPersonalWork.getWorkId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    redisPersonalWork.setStatus(work.getStatus());
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), personalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(objects)));
            subWork(objects, work, work.getPublisher());
            log.info("{}这里发送{}", work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(objects)));

            personalWork.setWorkAttribution(WorkAttribution1.ME_RELATED_WORK);
            personalWork.setReadState(1);
            personalWork.setIsNotCommission(1);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getExecutor(), personalWork);

            asynchronousAddEs(Constants.REDIS_EVENT + work.getExecutor(), personalWork);
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getExecutor(), 0, -1);
            assert list != null;
            pushData(work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            subWork(list, work, work.getExecutor());
            log.info("{}这里发送{}", work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
        //有待修改
        for (String id:uIds){
            personalWork.setWorkAttribution(WorkAttribution1.ME_RELATED_WORK);
            personalWork.setReadState(1);
            personalWork.setIsNotCommission(0);
            redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+id,personalWork);

            asynchronousAddEs(Constants.REDIS_EVENT+id,personalWork);
           List<Object> list=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
            assert list != null;
            pushData(id,JacksonUtil.toJSon(statisticalRoleCount(list)));
            subWork(list,work,id);
            log.info("{}这里发送{}",id, JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
    }

    @Override
    public void updateWorkStatus(String executorId, String latestNews, String status, Work work) {
        List<String> uIds=new ArrayList<>();
        Long time=new Date().getTime();
        if (work.getSuperiorId()!=null) {
            uIds = tests(work.getSuperiorId(), uIds);
        }

        if (work.getExecutor().equals(work.getPublisher())){
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    redisPersonalWork.setStatus(status);
                    redisPersonalWork.setTime(time);
                    if (work.getPublisher().equals(executorId)) {
                        redisPersonalWork.setReadState(0);
                    } else {
                        redisPersonalWork.setReadState(1);
                    }
                    switch (status) {
                        case WorkStatus.ONGOING:
                            redisPersonalWork.setIsNotCommission(1);
                            break;
                        case WorkStatus.AUDIT:
                            redisPersonalWork.setIsNotCommission(1);
                            break;
                        case WorkStatus.REVIEW:
                            redisPersonalWork.setIsNotCommission(1);
                            break;
                        default:
                            redisPersonalWork.setIsNotCommission(0);
                            break;
                    }

                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));


        }else {

            //发布者
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    redisPersonalWork.setStatus(status);
                    redisPersonalWork.setTime(time);
                    if (work.getPublisher().equals(executorId)) {
                        redisPersonalWork.setReadState(0);
                    } else {
                        redisPersonalWork.setReadState(1);
                    }
                    switch (status) {
                        case WorkStatus.ONGOING:
                            redisPersonalWork.setIsNotCommission(0);
                            break;
                        case WorkStatus.AUDIT:
                            redisPersonalWork.setIsNotCommission(1);
                            break;
                        case WorkStatus.REVIEW:
                            redisPersonalWork.setIsNotCommission(0);
                            break;
                        default:
                            redisPersonalWork.setIsNotCommission(0);
                            break;
                    }

                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            //执行者
            list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getExecutor(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getExecutor(), 1, redisPersonalWork);
                    redisPersonalWork.setStatus(status);
                    if (work.getPublisher().equals(executorId)) {
                        redisPersonalWork.setReadState(0);
                    } else {
                        redisPersonalWork.setReadState(1);
                    }
                    redisPersonalWork.setTime(time);
                    switch (status) {
                        case WorkStatus.ONGOING:
                            redisPersonalWork.setIsNotCommission(1);
                            break;
                        case WorkStatus.AUDIT:
                            redisPersonalWork.setIsNotCommission(0);
                            break;
                        case WorkStatus.REVIEW:
                            redisPersonalWork.setIsNotCommission(1);
                            break;
                        default:
                            redisPersonalWork.setIsNotCommission(0);
                            break;
                    }
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getExecutor(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getExecutor(), redisPersonalWork);
                }
            }
            pushData(work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
   if (uIds.size()!=0) {
       for (String uId:uIds) {
        List<Object>   list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + uId, 0, -1);
           for (Object object : list) {
               RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
               if (redisPersonalWork.getWorkId().equals(work.getId())) {
                   redisTemplate.opsForList().remove(Constants.REDIS_EVENT + uId, 1, redisPersonalWork);
                   redisPersonalWork.setStatus(status);
                   redisPersonalWork.setReadState(1);
                   redisPersonalWork.setTime(time);
                   redisPersonalWork.setLatestNews(latestNews);
                   redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + uId, redisPersonalWork);
                   asynchronousAddEs(Constants.REDIS_EVENT + uId, redisPersonalWork);
               }
           }
           pushData(uId, JacksonUtil.toJSon(statisticalRoleCount(list)));
       }
     }
    }



    @Override
    public void upDateWork(String executorId, String latestNews, Work work) {
        List<String> uIds=new ArrayList<>();
        if (work.getSuperiorId()!=null) {
            uIds = tests(work.getSuperiorId(), uIds);
        }
        Long time=new Date().getTime();
        if (work.getExecutor().equals(work.getPublisher())){
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    redisPersonalWork.setReadState(0);
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

        }else {

            //发布者
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    if (executorId.equals(work.getPublisher())) {
                        redisPersonalWork.setReadState(0);
                    }else {
                        redisPersonalWork.setReadState(1);
                    }
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            //执行者
            list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getExecutor(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getExecutor(), 1, redisPersonalWork);
                    redisPersonalWork.setReadState(1);
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getExecutor(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getExecutor(), redisPersonalWork);
                }
            }
            pushData(work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
        if (uIds.size()!=0) {
            for (String uId:uIds) {
             List<Object>  list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + uId, 0, -1);
                for (Object object : list) {
                    RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                    if (redisPersonalWork.getWorkId().equals(work.getId())) {
                        redisTemplate.opsForList().remove(Constants.REDIS_EVENT + uId, 1, redisPersonalWork);
                        redisPersonalWork.setReadState(1);
                        redisPersonalWork.setTime(time);
                        redisPersonalWork.setLatestNews(latestNews);
                        redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + uId, redisPersonalWork);
                        asynchronousAddEs(Constants.REDIS_EVENT + uId, redisPersonalWork);
                    }
                }
                pushData(uId, JacksonUtil.toJSon(statisticalRoleCount(list)));
            }
        }

    }

    @Override
    public void appraisal(String executorId, String latestNews, Work work){
        List<String> uIds=new ArrayList<>();
        if (work.getSuperiorId()!=null) {
            uIds = tests(work.getSuperiorId(), uIds);
        }
        Long time=new Date().getTime();
        if (work.getExecutor().equals(work.getPublisher())){
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    redisPersonalWork.setIsNotCommission(1);
                    redisPersonalWork.setReadState(0);
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));

        }else {
            //发布者
            List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getPublisher(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getPublisher(), 1, redisPersonalWork);
                    if (work.getPublisher().equals(executorId)) {
                        redisPersonalWork.setReadState(0);
                        redisPersonalWork.setIsNotCommission(0);
                    } else {
                        redisPersonalWork.setReadState(1);
                        redisPersonalWork.setIsNotCommission(1);
                    }
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getPublisher(), redisPersonalWork);
                }
            }
            pushData(work.getPublisher(), JacksonUtil.toJSon(statisticalRoleCount(list)));
            //执行者
            list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + work.getExecutor(), 0, -1);
            for (Object object : list) {
                RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                if (redisPersonalWork.getWorkId().equals(work.getId())) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + work.getExecutor(), 1, redisPersonalWork);
                    if (work.getExecutor().equals(executorId)) {
                        redisPersonalWork.setReadState(0);
                        redisPersonalWork.setIsNotCommission(0);
                    } else {
                        redisPersonalWork.setReadState(1);
                        redisPersonalWork.setIsNotCommission(0);
                    }
                    redisPersonalWork.setTime(time);
                    redisPersonalWork.setLatestNews(latestNews);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + work.getExecutor(), redisPersonalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + work.getExecutor(), redisPersonalWork);
                }
            }
            pushData(work.getExecutor(), JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
        if (uIds.size()!=0) {
            for (String uId:uIds) {
             List<Object>   list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + uId, 0, -1);
                for (Object object : list) {
                    RedisPersonalWork redisPersonalWork = (RedisPersonalWork) object;
                    if (redisPersonalWork.getWorkId().equals(work.getId())) {
                        redisTemplate.opsForList().remove(Constants.REDIS_EVENT + uId, 1, redisPersonalWork);
                        redisPersonalWork.setReadState(1);
                        redisPersonalWork.setTime(time);
                        redisPersonalWork.setLatestNews(latestNews);
                        redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + uId, redisPersonalWork);
                        asynchronousAddEs(Constants.REDIS_EVENT + uId, redisPersonalWork);
                    }
                }
                pushData(uId, JacksonUtil.toJSon(statisticalRoleCount(list)));
            }
        }

    }


    @Override
    public void readsStatus(String id, String eventId, int readState) {
        List<Object> list = redisTemplate.opsForList().range(Constants.REDIS_EVENT + id, 0, -1);
        if (readState == 1) {
            assert list != null;
            for (Object object : list) {
                RedisPersonalWork personalWork = (RedisPersonalWork) object;
                if (personalWork.getWorkId().equals(eventId)) {
                    redisTemplate.opsForList().remove(Constants.REDIS_EVENT + id, 1, personalWork);
                    personalWork.setReadState(0);
                    redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT + id, personalWork);
                    asynchronousAddEs(Constants.REDIS_EVENT + id, personalWork);
                }
            }
            pushData(id, JacksonUtil.toJSon(statisticalRoleCount(list)));
            log.info("{}这里发送{}", id, JacksonUtil.toJSon(statisticalRoleCount(list)));
        }
    }

    @Override
    public void loginFirstOneManualPush(String id) {

        log.info("redis :{}",Constants.REDIS_EVENT);
        List<Object> list= redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        assert list != null;
        RoleSum1 roleSum1= statisticalRoleCount(list);
        String receive=iUserService.findUserById(id).getUsername();
        log.info("{}调用了id查询的接口",receive);
        if (receive!=null) {
            messageTemplateService.beingPushed(receive, "/topic/note", JacksonUtil.toJSon(roleSum1));
        }else {
            log.info("{}数据库查询不到，请尝试",id);
        }
//
    }

    private void subWork(List<Object> list,Work work,String userId){
        for (Object object:list){
            RedisPersonalWork personalWork=(RedisPersonalWork)object;
            if (personalWork.getWorkId().equals(work.getSuperiorId())){
                redisTemplate.opsForList().remove(Constants.REDIS_EVENT+userId,1,personalWork);
                List<String> list1=personalWork.getSubtaskIds();
                list1.add(work.getId());
                personalWork.setSubtaskIds(list1);
                asynchronousAddEs(Constants.REDIS_EVENT + userId, personalWork);
                redisTemplate.opsForList().leftPush(Constants.REDIS_EVENT+userId,personalWork);
            }
        }
        pushData(userId,JacksonUtil.toJSon(statisticalRoleCount(list)));
    }

    private RoleSum1 statisticalRoleCount(List<Object> list){
        int role1=0,role2=0,role3=0,role4=0;
        int unread1=0,unread2=0,unread3=0,unread4=0;
        for (Object object:list){
            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            switch(redisPersonalWork.getWorkAttribution()){
                case WorkAttribution1.ME_RELATED_WORK :

                    role2++;
                    if (redisPersonalWork.getReadState()==1){
                        unread2=1;
                    }

                    if (redisPersonalWork.getIsNotCommission()==1){
                        role1++;
                        if (redisPersonalWork.getReadState()==1){
                            unread1=1;
                        }
                    }
                    break;
                case WorkAttribution1.ME_RESOLVE_WORK :
                    role3++;
                    if (redisPersonalWork.getReadState()==1){
                        unread3=1;
                    }

                    if (redisPersonalWork.getIsNotCommission()==1){
                        role1++;
                        if (redisPersonalWork.getReadState()==1){
                            unread1=1;
                        }
                    }
                    if (redisPersonalWork.getExecutorEqualRelease()==1){
                        role2++;
                        if (redisPersonalWork.getReadState()==1){
                            unread2=1;
                        }
                    }
                    break;
                case WorkAttribution1.ME_RELEASE_WORK :
                    role4++;
                    if (redisPersonalWork.getReadState()==1){
                        unread4=1;
                    }

                    if (redisPersonalWork.getIsNotCommission()==1){
                        role1++;
                        if (redisPersonalWork.getReadState()==1){
                            unread1=1;
                        }
                    }

                    if (redisPersonalWork.getExecutorEqualRelease()==1){
                        role2++;
                        if (redisPersonalWork.getReadState()==1){
                            unread2=1;
                        }
                    }
                    break;
                case WorkAttribution1.ME_RECEIVE_WORK :
                    role2++;
                    if (redisPersonalWork.getReadState()==1){
                        unread2=1;
                    }

                    if (redisPersonalWork.getIsNotCommission()==1){
                        role1++;
                        if (redisPersonalWork.getReadState()==1){
                            unread1=1;
                        }
                    }
                    break;
            }
        }
        return new RoleSum1(unread1,role1,unread2,role2,unread3,role3,unread4,role4);

    }

    private void pushData(String id,String payload){
        log.info("[Status,pushData] 传入的id值为：{} ", id);
        String receive=  iUserService.findUserById(id).getUsername();
        if (receive!=null) {
            messageTemplateService.beingPushed(receive, "/topic/note", payload);

        }else {
            log.info("{}数据库查询不到，请检查",id);
        }
    }

    //对象转es
    private EsSource eventToEs(RedisPersonalWork personalWork) {
        EsSource esSource = new EsSource();
        Map<String, Object> objectMap = new HashMap<>(20);
        objectMap.put("workId", personalWork.getWorkId());
        objectMap.put("title", personalWork.getTitle());
        objectMap.put("status", personalWork.getStatus());
        objectMap.put("release", personalWork.getRelease());
        objectMap.put("executor", personalWork.getExecutor());
        objectMap.put("readState", personalWork.getReadState());
        objectMap.put("workAttribution", personalWork.getWorkAttribution());
        objectMap.put("latestNews", personalWork.getLatestNews());
        objectMap.put("superiorId", personalWork.getSuperiorId());
        objectMap.put("time", personalWork.getTime());
        objectMap.put("subtaskIds", personalWork.getSubtaskIds());
        esSource.setJsonMap(objectMap);
        return esSource;
    }

    // 添加es
    private void asynchronousAddEs(String index,RedisPersonalWork personalWork){
        CompletableFuture.runAsync(() -> {
//            esUtil.save(index, eventToEs(personalWork));
            log.info("异步写入es完成");
        });

    }
}
