package com.zjty.tynotes.job.basic.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Attachment;
import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.entity.response.WorkVo;
import com.zjty.tynotes.job.basic.repository.AttachmentRepository;
import com.zjty.tynotes.job.basic.service.AttachmentService;
import com.zjty.tynotes.job.basic.service.ConversionService;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.service.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class ConversionServiceImpl implements ConversionService {
    @Autowired
    IUserService iUserService;

    @Autowired
    AttachmentRepository attachmentRepository;

    @Override
    public WorkVo workToVo(Work work) {
        log.info("开始转换对象");
        User pUser=iUserService.findUserById(work.getPublisher());

        User eUser=iUserService.findUserById(work.getExecutor());
        List<User> users=new ArrayList<>();
        List<String> uid=work.getCrewList();
        List<Attachment> attachments=new ArrayList<>();
        List<String> attachIds=work.getAttachment();

        if (uid!=null && uid.size()!=0){
            for (String id:uid){
                users.add(iUserService.findUserById(id));
            }
        }

        if (attachIds!=null && attachIds.size()!=0){
            for (String id:attachIds){
                attachments.add(attachmentRepository.findById(id).get());
            }
        }
        return new WorkVo(
                work.getId(),
        work.getSuperiorId(),
        work.getTitle(),
        work.getCreateTime(),
        work.getStateTime(),
        work.getEndTime(),
        work.getCompleteTime(),
        work.getUpdateTime(),
        pUser,
        eUser,
        users,
        attachments,
        work.getContent(),
        work.getWorkload(),
        work.getStatus(),
        work.getWorkCoefficient(),
        work.getPWorkload(),
        work.getWorkloadCount()
        );
    }
}
