package com.zjty.tynotes.job.status.service.impl;

import com.zjty.tynotes.job.common.Constants;
import com.zjty.tynotes.job.common.constant.WorkStatus;
import com.zjty.tynotes.job.common.exception.WorkAttribution1;
import com.zjty.tynotes.job.status.entity.EsListSum;
import com.zjty.tynotes.job.status.entity.RedisListSum;
import com.zjty.tynotes.job.status.entity.RedisPersonalWork;
import com.zjty.tynotes.job.status.service.TestSeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
@Service
public class TestSeeServiceImpl implements TestSeeService {

    @Autowired
    RedisTemplate<String,Object> redisTemplate;
    @Override
    public RedisListSum selectMeCommissionWork(String id, int page, int size) {
        List<RedisPersonalWork> list=new ArrayList<>();
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        for (Object object:objectList){
            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getIsNotCommission()==1){
                list.add(redisPersonalWork);
            }
        }
       return listSum(list,size,page);
    }

    @Override
    public RedisListSum selectMeRelatedWork(String id, int page, int size) {

        List<RedisPersonalWork> list=new ArrayList<>();
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        for (Object object:objectList){
            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RELATED_WORK || redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RECEIVE_WORK || redisPersonalWork.getExecutorEqualRelease()==1 ){
                list.add(redisPersonalWork);
            }

        }

        return listSum(list,size,page);
    }

    @Override
    public RedisListSum selectMeResolveWork(String id, int page, int size) {
        List<RedisPersonalWork> list=new ArrayList<>();
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        for (Object object:objectList){
            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RESOLVE_WORK){
                list.add(redisPersonalWork);
            }
        }
        return listSum(list,size,page);
    }

    @Override
    public RedisListSum selectMeReleaseWork(String id, int page, int size) {
        List<RedisPersonalWork> list=new ArrayList<>();
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        for (Object object:objectList){
            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getWorkAttribution()==WorkAttribution1.ME_RELEASE_WORK){
                list.add(redisPersonalWork);
            }
        }
        return listSum(list,size,page);
    }

    @Override
    public RedisListSum titleSelect(String id, int page, int size, String title) {
        List<RedisPersonalWork> list=new ArrayList<>();
        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
        for (Object object:objectList){
            RedisPersonalWork redisPersonalWork=(RedisPersonalWork)object;
            if (redisPersonalWork.getTitle().contains(title)){
                list.add(redisPersonalWork);
            }
        }

        return listSum(list,size,page);
    }

    private RedisListSum listSum(List<RedisPersonalWork> list,int size,int page){
        int count=list.size();
        if (size>count){
            return new RedisListSum(count,list);
        }
        int countPage=count/size;
        if (count%size!=0){
            countPage=countPage+1;
        }
        if (page>countPage){
            return new RedisListSum(count,list.subList((page-1)*size,countPage*size));
        } else {
            return  new RedisListSum(count,list.subList((page-1)*size,page*size));

        }
    }
}
