package com.zjty.tynotes.pas.task;

import com.zjty.tynotes.pas.dao.AuthorityDao;
import com.zjty.tynotes.pas.dao.PasUserDao;
import com.zjty.tynotes.pas.dao.RoleDao;
import com.zjty.tynotes.pas.dao.UserRoleDao;
import com.zjty.tynotes.pas.entity.*;
import com.zjty.tynotes.pas.service.IAuthorityService;
import com.zjty.tynotes.pas.service.IDepartmentService;
import com.zjty.tynotes.pas.service.IRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: mcj
 * @Date: 19-4-30 下午2:01
 * @Version 1.0
 */
@Component
public class Init implements CommandLineRunner {

    @Autowired
    PasUserDao pasUserDao;
    @Autowired
    private IAuthorityService iAuthorityService;

    @Autowired
    private IRoleService iRoleService;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private UserRoleDao userRoleDao;

    public User root;

    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;

    @Override
    public void run(String... args) throws Exception {
        List<Authority> authorities1 = new ArrayList<>();
        List<Authority> authorityList = authorityDao.findAll();
        List<String> authorityName = new ArrayList<>();
        if(authorityList!=null){
            for (Authority authority : authorityList) {
                authorityName.add(authority.getName());
            }
        }
        if(!authorityName.contains("查看任务")){
            authorities1.add(new Authority(null,"查看任务","能够查看员工的任务"));
        }
        if(!authorityName.contains("发布任务")){
            authorities1.add(new Authority(null,"发布任务","能够发布任务给其他用户"));
        }
        if(!authorityName.contains("分解任务")){
            authorities1.add(new Authority(null,"分解任务","对任务具有分解的功能"));
        }
        if(!authorityName.contains("删除任务")){
            authorities1.add(new Authority(null,"删除任务","能够对任务进行删除"));
        }
        if(!authorityName.contains("修改任务")){
            authorities1.add(new Authority(null,"修改任务","能够对任务进行修改"));
        }
        if(!authorityName.contains("查看人员")){
            authorities1.add(new Authority(null,"查看人员","能够查看人员"));
        }
        if(authorities1!=null){
            authorityDao.saveAll(authorities1);
        }


//        iRoleService.deleteAll();
        User user = pasUserDao.findByUsername("管理员");
        if(user!=null){
            root = user;
        }else{
            this.root = new User();
            Role role = new Role(null,"管理员","管理系统的人员",null,null,null);
            List<Authority> authorities = new ArrayList<>();
            Authority authority2 = new Authority(null,"用户管理","无");
            Authority authority1 = new Authority(null,"权限管理","无");
            Authority authority3 = new Authority(null,"角色管理","无");
            Authority authority4 = new Authority(null,"考勤管理","无");
            Authority authority5 = new Authority(null,"部门管理","无");

            authorities.add(authority2);
            authorities.add(authority1);
            authorities.add(authority3);
            authorities.add(authority4);
            authorities.add(authority5);
            role.setAuthorities(authorities);

            this.root.createUser();
            this.root.setUsername("root");

            root.setPassword("root");
            List<Role> roles = new ArrayList<>();
            roles.add(role);
            this.root.setRoles(roles);
            List<Authority> authorities2 = authorityDao.saveAll(authorities);

            List<Role> roles1 = roleDao.saveAll(roles);
            Role role1 = roles1.get(0);
            String id = role1.getId();
            List<RoleAuthority> roleAuthorities = new ArrayList<>();
            for (Authority authority : authorities2) {
                roleAuthorities.add(new RoleAuthority(null,id,authority.getId()));
            }
            User save = pasUserDao.save(this.root);
            UserRole userRole = new UserRole(null,save.getId(),id);
            userRoleDao.save(userRole);
            this.root.setPassword(bCryptPasswordEncoder.encode(root.getPassword()));
        }

;

//        User user1 = new User();
//        user1.createUser();
//        user1.setUsername("mcj1");
//        user1.setPassword("mcj1");
//        user1.setClock(0);
//        user1.setRoleId(role1.getId());
//        user1.setDepartId("2");
//
//
//        User user2 = new User();
//        user2.createUser();
//        user2.setUsername("mcj2");
//        user2.setPassword("mcj2");
//        user2.setClock(0);
//        user2.setRoleId(role1.getId());
//        user2.setDepartId("1");
//
//        User user3 = new User();
//        user3.createUser();
//        user3.setUsername("mcj3");
//        user3.setPassword("mcj3");
//        user3.setClock(0);
//        user3.setRoleId(role1.getId());
//        user3.setDepartId("2");
//
//
//        User user4 = new User();
//        user4.createUser();
//        user4.setUsername("mcj4");
//        user4.setPassword("mcj4");
//        user4.setClock(0);
//        user4.setRoleId(role1.getId());
//        user4.setDepartId("1");
//
//          pasUserDao.deleteAll();
//        pasUserDao.save(user1);
//        pasUserDao.save(user2);
//        pasUserDao.save(user3);
//        pasUserDao.save(user4);
//
//
//        iDepartmentService.deleteAll();
//        iDepartmentService.addDepartments(new ArrayList<>());
//
//        iGroupService.deleteAll();
//        ArrayList<Group> arrayList = new ArrayList<>();
//        Group group1 = new Group();
//        Group group2 = new Group();
//        group1.setName("1号小组");
//        group2.setName("2号小组");
//        arrayList.add(group1);
//        arrayList.add(group2);
//        iGroupService.addGroup(arrayList);
//
//        iJobService.deleteAll();
//        Job job = new Job();
//        job.setName("岗位1");
//
//        iJobService.addJob(job);
    }
}
