package com.zjty.tynotes.search.subject.entity;


import lombok.AllArgsConstructor;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * @author LJJ
 * on 2019-04-24
 */
@Data
@AllArgsConstructor
@NotEmpty
public final class EsSearchArg {

    /**
     * 发布者
     */
    private String publisher;

    /**
     * 执行者
     */
    private String executor;

    /**
     * 审核者
     */
    private String inspector;

    /**
     * 关注者
     */
    private String viewer;

    /**
     * 发布时间
     */
    private Long publishTime;

    /**
     * 完结时间
     */
    private Long endTime;

    /**
     * 任务标题
     */
    private String title;

    /**
     * 附件名称
     */
    private String annexName;

    /**
     * 任务状态
     */
    private String status;

    /**
     * 页数
     */
    private Integer page;

    /**
     * 每页大小
     */
    private Integer size;

    private EsSearchArg(Builder builder) {
        this.publisher = builder.publisher;
        this.executor = builder.executor;
        this.inspector = builder.inspector;
        this.viewer = builder.viewer;
        this.publishTime = builder.publishTime;
        this.endTime = builder.endTime;
        this.title = builder.title;
        this.annexName = builder.annexName;
        this.status = builder.status;
        this.page = builder.page;
        this.size = builder.size;
    }

    /**
     * builder构建
     */
    public static class Builder {

        private String publisher;

        private String executor;

        private String inspector;

        private String viewer;

        private Long publishTime;

        private Long endTime;

        private String title;

        private String annexName;

        private String status;

        private Integer page;

        private Integer size;

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder executor(String executor) {
            this.executor = executor;
            return this;
        }

        public Builder inspector(String inspector) {
            this.inspector = inspector;
            return this;
        }

        public Builder viewer(String viewer) {
            this.viewer = viewer;
            return this;
        }

        public Builder publishTime(Long publishTime) {
            this.publishTime = publishTime;
            return this;
        }

        public Builder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder annexName(String annexName) {
            this.annexName = annexName;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            return this;
        }


        public EsSearchArg build() {
            return new EsSearchArg(this);
        }

    }
}
