package com.zjty.tynotes.weekly.subject.service.impl;

import com.zjty.tynotes.job.basic.entity.database.Work;
import com.zjty.tynotes.job.basic.repository.WorkRepository;
import com.zjty.tynotes.job.status.entity.Personnel;
import com.zjty.tynotes.job.status.service.InternalService;
import com.zjty.tynotes.pas.dao.*;
import com.zjty.tynotes.pas.entity.*;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import com.zjty.tynotes.weekly.subject.entity.vo.UserVo;
import com.zjty.tynotes.weekly.subject.service.UserManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

import java.lang.reflect.Array;
import java.util.*;

/**
 * @Author gwj
 * @create 2020/3/2 13:07
 */
@Service
public class UserManageServiceImpl implements UserManageService {
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private PasUserDao pasUserDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RoleAuthorityDao roleAuthorityDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private InternalService internalService;

    @Override
    public User findUserById(String id) {
        Optional<User> optional = pasUserDao.findById(id);
        User user = null;
        if(optional.isPresent()){
            user = optional.get();
            List<String> roleIds = new ArrayList<>();
            List<UserRole> userRoles = userRoleDao.findAllByUserId(user.getId());
            for (UserRole userRole : userRoles) {
                roleIds.add(userRole.getRoleId());
            }
            List<Role> roles = roleDao.findAllByIdIn(roleIds);
            user.setRoles(roles);
        }
        return user;
    }

    /**
     * 查询人员列表
     * @param pageRequest
     * @return
     */
    @Override
    public PageResponse<UserVo> findUserList(PageRequest pageRequest) {
        List<UserVo> userVos = new ArrayList<>();
        PageResponse<UserVo> pageResponse = new PageResponse();
        String deId = pageRequest.getDeId();
        List<User> users = pasUserDao.findAll();
        List<User> userList = new ArrayList<>();
        for (User user : users) {
            List<String> departmentIds = user.getDepartmentIds();
            for (String departmentId : departmentIds) {
                if(departmentId.equals(deId)){
                    userList.add(user);
                }
            }
        }
        int currentPage = pageRequest.getCurrentPage();
        int pageSize = pageRequest.getPageSize();
        int start = (currentPage-1)*pageSize+1;
        int end = start+pageSize;
        if(userList.size()>=end){
            List<User> users1 = userList.subList(start-1, end-1);
            for (User user : users1) {
                userVos.add(new UserVo(user));
            }
            pageResponse.setRows(userVos);
            pageResponse.setTotalCount(userList.size());
            return pageResponse;
        }else if(start<=userList.size()&&end>=userList.size()){
            List<User> users1 = userList.subList(start-1, userList.size()-1);
            for (User user : users1) {
                userVos.add(new UserVo(user));
            }
            pageResponse.setRows(userVos);
            pageResponse.setTotalCount(userList.size());
            return pageResponse;
        }
        return null;
//        List<User> users = new ArrayList<>();
//        PageResponse<UserVo> pageResponse = new PageResponse<>();
//        pageResponse.setCurrentPage(pageRequest.getCurrentPage());
//        pageResponse.setPageSize(pageRequest.getPageSize());
//        if(pageRequest.getDeId()!=null){
//            users = pasUserDao.findAllByDepartmentId(pageRequest.getId());
//        }else{
//            List<Department> departmentList = findDepartmentList(pageRequest.getId());
//            List<String> departmentIds = new ArrayList<>();
//            for (Department department : departmentList) {
//                departmentIds.add(department.getId());
//            }
//            users = pasUserDao.findAllByDepartmentIdIn(departmentIds);
//        }
//        List<String> userIds = new ArrayList<>();
//        for (User user : users) {
//            userIds.add(user.getId());
//        }
//        List<Personnel> personnels = internalService.personnels(userIds);
//        List<UserVo> userVos = new ArrayList<>();
//        for (User user : users) {
//            for (Personnel personnel : personnels) {
//                if(user.getId().equals(personnel.getId())){
//                    UserVo userVo = new UserVo(user);
//                    userVo.setWorkCount(personnel.getCount());
//                    userVos.add(userVo);
//                }
//            }
//        }
//
//        if(pageRequest.getSort()!=null && pageRequest.getSort()==1) {
//            Collections.sort(userVos, new Comparator<UserVo>() {
//                @Override
//                public int compare(UserVo o1, UserVo o2) {
//                    return o1.getWorkCount()-o2.getWorkCount();
//                }
//            });
//        }else{
//            Collections.sort(userVos, new Comparator<UserVo>() {
//                @Override
//                public int compare(UserVo o1, UserVo o2) {
//                    return o2.getWorkCount()-o1.getWorkCount();
//                }
//            });
//        }
//        int startNum=(pageResponse.getCurrentPage()-1)*10+1;
//        int endNum = startNum+pageResponse.getPageSize();
//        List<UserVo> userVos1 = userVos.subList(startNum - 1, endNum - 1);
//        pageResponse.setRows(userVos1);
//        pageResponse.setTotalPage((userVos.size()/pageResponse.getPageSize())+1);
//        pageResponse.setTotalCount(userVos.size());
//        return null;
    }


    /**
     * 查询可查看的部门列表
     * @param id
     * @return
     */
    @Override
    public List<Department> findDepartmentList(String id) {
        List<UserRole> userRoles = userRoleDao.findAllByUserId(id);
        List<String> roleIds = new ArrayList<>();
        List<String> departmentIds = new ArrayList<>();
        for (UserRole userRole : userRoles) {
            roleIds.add(userRole.getRoleId());
        }
        List<Role> roles = roleDao.findAllByIdIn(roleIds);
        for (Role role : roles) {
            List<RoleAuthority> roleAuthorities = roleAuthorityDao.findAllByRoleId(role.getId());
            List<String> authorityIds = new ArrayList<>();
            for (RoleAuthority roleAuthority : roleAuthorities) {
                authorityIds.add(roleAuthority.getAuthorityId());
            }
            Authority authority = authorityDao.findByIdInAndName(authorityIds, "查看人员");
            if(authority!=null){
                String departmentId = role.getDepartmentId();
                departmentIds.add(departmentId);
            }
        }
        List<String> departmentIdList = new ArrayList<>();

        getDepartments(departmentIdList,departmentIds);
        List<Department> departments = departmentDao.findAllByIdIn(departmentIdList);

        return departments;
    }

    public void getDepartments(List<String> departmentIdList,List<String> departmentIds) {
        for (String string : departmentIds) {
            if(departmentIdList.contains(string)){
                continue;
            }

            List<Department> departmentList = departmentDao.findAllByParentId(string);
            List<String> departments = new ArrayList<>();
            for (Department department : departmentList) {
                departments.add(department.getId());
            }
            departmentIdList.add(string);
            getDepartments(departmentIdList,departments);
        }
    }

    @Override
    public boolean updatePas(User user) {
        String encode = bCryptPasswordEncoder.encode(user.getPassword());
        user.setPassword(encode);
        pasUserDao.save(user);
        return true;
    }

    @Override
    public User findfindUserByUsername(String username) {
        return pasUserDao.findByUsername(username);
    }

    @Override
    public boolean updateSelf(User user,User userById) {
        userById.setPhone1(user.getPhone1());
        userById.setPhone2(user.getPhone2());
        userById.setEmail(user.getEmail());
        userById.setAddress(user.getAddress());
        return false;
    }

    private List<Department> findDepartmentList(List<Department> des, List<Department> deps){
        for (Department department : deps) {
            if(!des.contains(department)){
                des.add(department);
            }
        }
        for (Department department : deps) {
            List<Department> departments = departmentDao.findAllByParentId(department.getId());
            if(departments!=null){
                findDepartmentList(des,departments);
            }
        }
        return des;
    }



}
