package com.zjty.tynotes.attendance.entity.vo;

import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author gwj
 * @create 2020/3/25 10:00
 */
@Data
@AllArgsConstructor
@ApiModel(value = "返回前台的个人考勤统计信息", description = "返回前台的个人考勤统计信息")
public class UserAttenVo {

    @ApiModelProperty(value = "用户编号",example = "1")
    private String userId;

    @ApiModelProperty(value = "用户姓名",example = "1")
    private String name;

    @ApiModelProperty(value = "应出勤天数",example = "1")
    private Integer attendanceDay;

    @ApiModelProperty(value = "实际出勤天数",example = "1")
    private Float realAttendanceDay;

    @ApiModelProperty(value = "公出天数",example = "1")
    private Float outSideBusinessDay;

    @ApiModelProperty(value = "迟到天数",example = "1")
    private Integer lateDay;

    @ApiModelProperty(value = "早退天数",example = "1")
    private Integer leaveEarlyDay;

    @ApiModelProperty(value = "出差天数",example = "1")
    private Float outWorkDay;

    @ApiModelProperty(value = "请假天数",example = "1")
    private Float sickLeaveDay;

    @ApiModelProperty(value = "加班时长",example = "1")
    private Integer overWorkHours;

    @ApiModelProperty(value = "旷工天数",example = "1")
    private Float absenteeismDay;

    public UserAttenVo() {
        this.attendanceDay = 0;
        this.realAttendanceDay = 0f;
        this.outSideBusinessDay = 0f;
        this.lateDay = 0;
        this.leaveEarlyDay = 0;
        this.outWorkDay = 0f;
        this.sickLeaveDay = 0f;
        this.overWorkHours = 0;
        this.absenteeismDay = 0f;
    }


    public void computerRealAttendanceDay(){
        realAttendanceDay = attendanceDay - outSideBusinessDay - outWorkDay - sickLeaveDay - absenteeismDay;
    }
}
