package com.zjty.tynotes.job.basic.service;

import com.zjty.tynotes.job.basic.entity.database.Attachment;
import com.zjty.tynotes.job.basic.service.impl.AttachmentServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 14:49
 * <p>@author : C
 * 实现类见↓
 *
 * @see AttachmentServiceImpl
 */
@Service
public interface AttachmentService {

    /**
     * 添加Attachment
     * 不可附带id
     *
     * @param attachment Attachment对象
     * @return 新保存对象的id
     */
    String add(Attachment attachment);

    /**
     * 根据workId新增Attachment并与所属Work建立关系
     * 不可附带id
     *
     * @param attachment Attachment对象
     * @param workId     所属工作id
     * @return Attachment对象的id
     */
    String add(Attachment attachment, String workId);

    /**
     * 根据workId新增Attachment并与所属Work建立关系
     * 不可附带id
     *
     * @param attachments Attachment集合对象
     * @param workId     所属工作id
     * @return Attachment对象的id
     */
    String add(List<Attachment> attachments, String workId);

    /**
     * 修改Attachment
     * 必须附带id
     *
     * @param attachment Attachment对象
     * @return 更新对象的id
     */
    String modify(Attachment attachment);

    /**
     * 查找指定id的Work
     *
     * @param workId 指定id
     * @return Work对象
     */
    Attachment findById(String attachmentId);

    /**
     * 查询所有
     *
     * @return 对象集合
     */
    List<Attachment> findAll();

    /**
     * 根据id集合查询所有
     *
     * @param ids id集合
     * @return 对象集合
     */
    List<Attachment> findAll(List<String> ids);

    /**
     * 根据id删除
     *
     * @param id 指定id
     */
    void delete(String id);

    /**
     * 删除所有数据
     */
    void deleteAll();
}
