package com.zjty.tynotes.job.basic.service;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;

import java.util.List;


public interface ScoreCoefficientService {
    /**
     * 新增工作
     * 不可附带id
     * 判断上级任务id是否存在，存在者减去这次任务设置的分数
     * @param scoreCoefficient 考评对象
     * @return 新增对象的id
     */
    String add(ScoreCoefficient scoreCoefficient);

    /**
     * 修改工作
     * 必须附带id
     *
     * @param scoreCoefficient 考评对象
     * @return 更新对象的id
     */
    String modify(ScoreCoefficient scoreCoefficient);

    /**
     * 指定id的考评是否存在是否存在
     *
     * @param Id 指定id
     * @return 是否存在
     */
    Boolean idExists(String Id);



    /**
     * 查找指定workid的考评信息
     *
     * @param id workid
     * @return ScoreCoefficient 对象
     */
    ScoreCoefficient findById(String id);


    /**
     * 查询所有发布者为考评的考评对象
     */

    List<ScoreCoefficient> selectSorct2IsNull();
}
