package com.zjty.tynotes.pas.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;

/**
 * @Author gwj
 * @create 2020/3/1 9:38
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "参数", description = "参数说明")
@Document(collection = "pas_config")
public class Config {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;


    @NotEmpty(message = "上班时间")
    @ApiModelProperty(value = "上班时间",example = "2019/2/2")
    private String workTime;

    @NotEmpty(message = "下班时间")
    @ApiModelProperty(value = "下班时间",example = "2019/2/2")
    private String afterWorkTime;

    @NotEmpty(message = "每日考勤基础分")
    @ApiModelProperty(value = "每日考勤基础分",example = "2")
    private String score;

    @NotEmpty(message = "迟到次数")
    @ApiModelProperty(value = "迟到次数",example = "3")
    private String lateNum;

    @NotEmpty(message = "迟到15分钟以上扣分")
    @ApiModelProperty(value = "迟到15分钟以上扣分",example = "2")
    private String latePointsFifteen;

    @NotEmpty(message = "迟到半天扣分")
    @ApiModelProperty(value = "迟到半天扣分",example = "4")
    private String latePointsHalfOfDay;

    @NotEmpty(message = "事假半天扣分")
    @ApiModelProperty(value = "事假半天",example = "2")
    private String thingHalfOfDay;

    @NotEmpty(message = "病假次数")
    @ApiModelProperty(value = "病假次数",example = "8")
    private String sickNum;

    @NotEmpty(message = "调休半天扣分")
    @ApiModelProperty(value = "调休半天扣分",example = "2")
    private String paidHalfOfDayLeave;

    @NotEmpty(message = "调休一天扣分")
    @ApiModelProperty(value = "调休一天扣分",example = "2")
    private String paidDayLeave;

    @NotEmpty(message = "月补卡数")
    @ApiModelProperty(value = "月补卡数",example = "5")
    private String addCardNum;

    @NotEmpty(message = "加班一小时加分")
    @ApiModelProperty(value = "加班一小时加分",example = "0.25")
    private String workOverScore;

    @NotEmpty(message = "全天旷工扣分")
    @ApiModelProperty(value = "全天旷工扣分",example = "6")
    private String absenteeism;

    @NotEmpty(message = "事假一天扣分")
    @ApiModelProperty(value = "事假一天扣分",example = "4")
    private String thingDay;


}
