package com.zjty.tynotes.attendance.controller;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiAttendanceListRecordRequest;
import com.dingtalk.api.request.OapiAttendanceListRequest;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.response.OapiAttendanceListRecordResponse;
import com.dingtalk.api.response.OapiAttendanceListResponse;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.taobao.api.ApiException;
import com.zjty.tynotes.attendance.entity.CardResult;
import com.zjty.tynotes.attendance.task.CardTask;
import com.zjty.tynotes.attendance.task.MyInit;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/4/3 9:37
 */
@Api(tags = "考勤模块", protocols = "http")
@RestController
@RequestMapping("/ding/test")
@AutoDocument
public class DingTestController {
    @Autowired
    private MyInit myInit;
    @Autowired
    private CardTask cardTask;

    @GetMapping("/token")
    public Object token(){
        List<String> responses = new ArrayList<>();
        myInit.getToken();
        myInit.getDepartmentList();
        myInit.getUserList();
        List<String> userIds = myInit.userIds;
        DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/get");
        OapiUserGetRequest request = new OapiUserGetRequest();
        request.setHttpMethod("GET");
        userIds.forEach(str->{
            request.setUserid(str);
            try {
                OapiUserGetResponse response = client.execute(request, myInit.token);
                responses.add(response.getName());
            } catch (ApiException e) {
                e.printStackTrace();
            }
        });
        System.out.println(responses.size());
        return responses;
    }

    @GetMapping("/card")
    public Object card(){
        myInit.getToken();
        myInit.getDepartmentList();
        myInit.getUserList();
        List<String> userIds = myInit.userIds;

        DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/attendance/listRecord");
        OapiAttendanceListRecordRequest request = new OapiAttendanceListRecordRequest();
        request.setCheckDateFrom("2020-04-04 00:00:00");
        request.setCheckDateTo("2020-04-10 00:00:00");
        request.setUserIds(userIds);
        try {
            OapiAttendanceListRecordResponse execute = client.execute(request,myInit.token);
            List<OapiAttendanceListRecordResponse.Recordresult> recordresult = execute.getRecordresult();
            return recordresult;
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return null;
    }

    @GetMapping("/score")
    public Object score(){
        String month = "2020-04";
        Double aDouble = cardTask.calcuteScore(month);
        return aDouble;
    }
}
