package com.zjty.tynotes.job.status.service;

import com.zjty.tynotes.job.status.entity.EsListSum;
import com.zjty.tynotes.job.status.entity.RedisListSum;

public interface TestSeeService {

    /**
     * 根据人员id查看我的代办任务列表
     * @param id
     * @param page
     * @param size
     * @return
     */
    RedisListSum selectMeCommissionWork(String id, int page, int size);

    /**
     * 根据人员id查看我的相关任务列表
     * @param id
     * @param page
     * @param size
     * @return
     */
    RedisListSum selectMeRelatedWork(String id, int page, int size);
    /**
     *根据人员id查看我分解的任务列表
     * @param id
     * @param page
     * @param size
     * @return
     */
    RedisListSum selectMeResolveWork(String id, int page, int size);
    /**
     *根据人员id查看我发布的任务列表
     * @param id
     * @param page
     * @param size
     * @return
     */
    RedisListSum selectMeReleaseWork(String id, int page, int size);

    /**
     * 标题查询
     *
     * @param id   　人员id
     * @param page 　页码
     * @param size 　每页显示的条数
     * @param title 事件的标题
     * @return 给前端对象集合 和条数
     */
    RedisListSum titleSelect(String id, int page, int size, String title);

}
