//package com.zjty.tynotes.job.status.service.impl;
//
//import com.fasterxml.jackson.core.type.TypeReference;
//import com.zjty.tynotes.job.common.Constants;
//import com.zjty.tynotes.job.status.entity.EsListSum;
//import com.zjty.tynotes.job.status.entity.RedisPersonalWork;
//import com.zjty.tynotes.job.status.service.WorkShowSeeService;
//import com.zjty.tynotes.job.status.utils.JacksonUtil;
//import com.zjty.tynotes.search.subject.entity.CollectionRs;
//import com.zjty.tynotes.search.subject.entity.EsSearchArg;
//import com.zjty.tynotes.search.subject.service.EsUtil;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.redis.core.RedisTemplate;
//import org.springframework.stereotype.Service;
//
//import java.util.*;
//
//@Service
//@Slf4j
//public class WorkShowSeeServiceImpl implements WorkShowSeeService {
//    @Autowired
//    EsUtil esUtil;
//
//    @Autowired
//    RedisTemplate<String,Object> redisTemplate;
//    @Override
//    public EsListSum selectMeWork(String id, int page, int size) {
//        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
//        CollectionRs collection=esUtil.getMeTask(id,new EsSearchArg.Builder().page(page).size(size).build());
//        assert objectList != null;
//        List<RedisPersonalWork> list=redisToEs(objectList,collection.getSource());
//        list.sort(Comparator.comparing(RedisPersonalWork::getTime).reversed());
//        return new EsListSum(collection.getTotal(),list);
//    }
//
//    @Override
//    public EsListSum selectMeReceiveWork(String id, int page, int size) {
//        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
//
//        //分解任务中的子任务
//        List<String> list=new ArrayList<>();
//        //没有子任务的分解任务
//        List<String> list1=new ArrayList<>();
//        List<RedisPersonalWork> redisPersonalWorks=new ArrayList<>();
//        for (Object object:objectList){
//            RedisPersonalWork redisPersonalWork=(RedisPersonalWork) object;
//            if (redisPersonalWork.getSubtaskIds()!=null){
//                list.addAll(redisPersonalWork.getSubtaskIds());
//            }else {
//                list1.add(redisPersonalWork.getWorkId());
//            }
//        }
//        list1.removeAll(list);
//
//        for (Object object:objectList){
//            RedisPersonalWork redisPersonalWork=(RedisPersonalWork) object;
//            for (String ids:list1){
//                if (redisPersonalWork.getWorkId().equals(ids)){
//                    redisPersonalWorks.add(redisPersonalWork);
//                }
//            }
//        }
//
//
//        return new EsListSum((long) redisPersonalWorks.size(),redisPersonalWorks);
//    }
//
//    @Override
//    public EsListSum selectMeResolveWork(String id, int page, int size) {
//        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
//        CollectionRs collection=esUtil.getMeResolveTask(id,new EsSearchArg.Builder().page(page).size(size).build());
//        assert objectList != null;
//        List<RedisPersonalWork> list=redisToEs(objectList,collection.getSource());
//        list.sort(Comparator.comparing(RedisPersonalWork::getTime).reversed());
//        return new EsListSum(collection.getTotal(),list);
//    }
//
//    @Override
//    public EsListSum selectMeReleaseWork(String id, int page, int size) {
//
//        List<Object> objectList=redisTemplate.opsForList().range(Constants.REDIS_EVENT+id,0,-1);
//        CollectionRs collection=esUtil.getMeReleaseTask(id,new EsSearchArg.Builder().page(page).size(size).build());
//        assert objectList != null;
//        List<RedisPersonalWork> list=redisToEs(objectList,collection.getSource());
//        list.sort(Comparator.comparing(RedisPersonalWork::getTime).reversed());
//        return new EsListSum(collection.getTotal(),list);
//    }
//
//    @Override
//    public EsListSum titleSelect(String id, int page, int size, String title) {
//        CollectionRs collection=esUtil.getTaskByTitle(id,title,page,size);
//        String s = JacksonUtil.toJSon(collection.getSource());
//        List<RedisPersonalWork> eventTitles = JacksonUtil.readValue(s, new TypeReference<List<RedisPersonalWork>>() {
//        });
//        assert eventTitles != null;
//        eventTitles.sort(Comparator.comparing(RedisPersonalWork::getTime).reversed());
//        return new EsListSum(collection.getTotal(),eventTitles);
//    }
//
//
//    private List<RedisPersonalWork> redisToEs(List<Object> objectList, List<Map<String,Object>> esList){
//        List<RedisPersonalWork> eventTitles=new ArrayList<>();
//        for (Object obj:objectList){
//            RedisPersonalWork eventTitle=(RedisPersonalWork)obj;
//            for (Map<String,Object> map:esList){
//                if (eventTitle.getWorkId().equals(map.get("workId"))){
//                    eventTitles.add(eventTitle);
//                }
//            }
//        }
//        return eventTitles;
//    }
//
//
//
//}
