package com.dingtalk.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;
import java.util.List;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.dingtalk.api.DingTalkConstants;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.json.JSONWriter;
import com.dingtalk.api.response.OapiSmartappFormInstanceAddResponse;

/**
 * TOP DingTalk-API: dingtalk.oapi.smartapp.form.instance.add request
 * 
 * @author top auto create
 * @since 1.0, 2019.11.30
 */
public class OapiSmartappFormInstanceAddRequest extends BaseTaobaoRequest<OapiSmartappFormInstanceAddResponse> {
	
	

	/** 
	* 表单应用ID
	 */
	private String appUuid;

	/** 
	* 插入数据列表
	 */
	private String dataList;

	/** 
	* 表单ID
	 */
	private String formCode;

	/** 
	* 操作人ID
	 */
	private String operatorUserid;

	public void setAppUuid(String appUuid) {
		this.appUuid = appUuid;
	}

	public String getAppUuid() {
		return this.appUuid;
	}

	public void setDataList(String dataList) {
		this.dataList = dataList;
	}

	public void setDataList(List<FormInstanceWriteUnitVo> dataList) {
		this.dataList = new JSONWriter(false,false,true).write(dataList);
	}

	public String getDataList() {
		return this.dataList;
	}

	public void setFormCode(String formCode) {
		this.formCode = formCode;
	}

	public String getFormCode() {
		return this.formCode;
	}

	public void setOperatorUserid(String operatorUserid) {
		this.operatorUserid = operatorUserid;
	}

	public String getOperatorUserid() {
		return this.operatorUserid;
	}

	public String getApiMethodName() {
		return "dingtalk.oapi.smartapp.form.instance.add";
	}

	private String topResponseType = Constants.RESPONSE_TYPE_DINGTALK_OAPI;

     public String getTopResponseType() {
        return this.topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

     public String getTopApiCallType() {
        return DingTalkConstants.CALL_TYPE_OAPI;
     }

     private String topHttpMethod = DingTalkConstants.HTTP_METHOD_POST;

     public String getTopHttpMethod() {
     	return this.topHttpMethod;
     }

     public void setTopHttpMethod(String topHttpMethod) {
        this.topHttpMethod = topHttpMethod;
     }

     public void setHttpMethod(String httpMethod) {
         this.setTopHttpMethod(httpMethod);
     }

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_uuid", this.appUuid);
		txtParams.put("data_list", this.dataList);
		txtParams.put("form_code", this.formCode);
		txtParams.put("operator_userid", this.operatorUserid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OapiSmartappFormInstanceAddResponse> getResponseClass() {
		return OapiSmartappFormInstanceAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(appUuid, "appUuid");
		RequestCheckUtils.checkObjectMaxListSize(dataList, 50, "dataList");
		RequestCheckUtils.checkNotEmpty(formCode, "formCode");
		RequestCheckUtils.checkNotEmpty(operatorUserid, "operatorUserid");
	}
	
	/**
	 * 组件值列表
	 *
	 * @author top auto create
	 * @since 1.0, null
	 */
	public static class FormData extends TaobaoObject {
		private static final long serialVersionUID = 8436812186293522846L;
		/**
		 * 扩展值
		 */
		@ApiField("extend_value")
		private String extendValue;
		/**
		 * 组件字段名
		 */
		@ApiField("name")
		private String name;
		/**
		 * 组件值
		 */
		@ApiField("value")
		private String value;
	
		public String getExtendValue() {
			return this.extendValue;
		}
		public void setExtendValue(String extendValue) {
			this.extendValue = extendValue;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getValue() {
			return this.value;
		}
		public void setValue(String value) {
			this.value = value;
		}
	}
	
	/**
	 * 插入数据列表
	 *
	 * @author top auto create
	 * @since 1.0, null
	 */
	public static class FormInstanceWriteUnitVo extends TaobaoObject {
		private static final long serialVersionUID = 3124983533426483983L;
		/**
		 * 业务主键
		 */
		@ApiField("biz_id")
		private String bizId;
		/**
		 * 数据负责人ID列表
		 */
		@ApiListField("charger_userid_list")
		@ApiField("string")
		private List<String> chargerUseridList;
		/**
		 * 数据创建人ID
		 */
		@ApiField("creator_userid")
		private String creatorUserid;
		/**
		 * 组件值列表
		 */
		@ApiListField("form_component_values")
		@ApiField("form_data")
		private List<FormData> formComponentValues;
		/**
		 * 协同人ID列表
		 */
		@ApiListField("participant_userid_list")
		@ApiField("string")
		private List<String> participantUseridList;
	
		public String getBizId() {
			return this.bizId;
		}
		public void setBizId(String bizId) {
			this.bizId = bizId;
		}
		public List<String> getChargerUseridList() {
			return this.chargerUseridList;
		}
		public void setChargerUseridList(List<String> chargerUseridList) {
			this.chargerUseridList = chargerUseridList;
		}
		public String getCreatorUserid() {
			return this.creatorUserid;
		}
		public void setCreatorUserid(String creatorUserid) {
			this.creatorUserid = creatorUserid;
		}
		public List<FormData> getFormComponentValues() {
			return this.formComponentValues;
		}
		public void setFormComponentValues(List<FormData> formComponentValues) {
			this.formComponentValues = formComponentValues;
		}
		public List<String> getParticipantUseridList() {
			return this.participantUseridList;
		}
		public void setParticipantUseridList(List<String> participantUseridList) {
			this.participantUseridList = participantUseridList;
		}
	}
	

}