package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author gwj
 * @create 2020/3/26 9:36
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "个人考勤信息", description = "个人考勤信息")
@Document(collection = "ding_attendepart")
public class AttendanceDepartment {
    private String id;

    @ApiModelProperty(value = "用户id",example = "1")
    private String userId;

    @ApiModelProperty(value = "用户姓名",example = "1")
    private String name;

    @ApiModelProperty(value = "应出勤天数",example = "1")
    private Integer attendanceDay;

    @ApiModelProperty(value = "实际出勤天数",example = "1")
    private Float realAttendanceDay;

    @ApiModelProperty(value = "公出天数",example = "1")
    private Float reasonableOutWorkDay;

    @ApiModelProperty(value = "迟到天数",example = "1")
    private Integer lateDay;

    @ApiModelProperty(value = "早退天数",example = "1")
    private Integer earlyDay;

    @ApiModelProperty(value = "出差天数",example = "1")
    private Float OutWorkDay;

    @ApiModelProperty(value = "请假天数",example = "1")
    private Float offFromWorkDay;
}
