package com.zjty.tynotes.job.basic.entity.database;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * <p>Description : tynotes
 * <p>Date : 2019/4/22 15:17
 * <p>@author : C
 * 留言（评论）
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "留言", description = "留言对象")
public class Comment {

    /**
     * id
     */
    @Id
    @ApiModelProperty(value = "id", example = "id", notes = "若新增数据则不可附带id.更新已有数据则必须附带id")
    private String id;

    /**
     * 评论者id
     */
    @NotNull
    @ApiModelProperty(value = "评论者id", example = "user id")
    private String commentator;

    /**
     * 评论时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "评论创建时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 评论时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "评论更新时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**
     * 内容
     */
    @NotNull
    @ApiModelProperty(value = "内容", example = "some content")
    private String content;

}
