package com.zjty.tynotes.job.basic.entity.database;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * <p>Description : tynotes
 * <p>Date : 2019/4/22 14:58
 * <p>@author : C
 * 工作记录
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "工作", description = "工作对象")
public class Work {
    /**
     * id
     */
    @Id
    @ApiModelProperty(value = "id.若新增数据则不可附带id.更新已有数据则必须附带id.", example = "id", notes = "若新增数据则不可附带id.更新已有数据则必须附带id")
    private String id;

    /**
     * 上级任务id
     */
    @Id
    @ApiModelProperty(value = "上级任务id", example = "superiorId")
    private String superiorId;
    /**
     * 标题
     */
    @NotNull
    @ApiModelProperty(value = "标题", example = "请输入标题")
    private String title;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 任务开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "开始时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date stateTime;

    /**
     * 任务结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "结束时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
    /**
     * 预计完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "预计完成时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date completeTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "更新时间", example = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /*相关用户 同一个人不能同时担任多种职位*/
    /**
     * 发布者id
     */
    @NotNull
    @ApiModelProperty(value = "发布者的用户id.", example = "id")
    private String publisher;
    /**
     * 执行者id
     */
    @NotNull
    @ApiModelProperty(value = "组长id.", example = "id")
    private String executor;

    /**
     * 组员id集合
     */
    @NotNull
    @ApiModelProperty(value = "组原id集合.", example = "[\"id\",\"id\"]")
    private List<String> crewList;

    /**
     * 附件id
     */
    @NotNull
    @ApiModelProperty(value = "附件的id集合.", example = "[\"id\",\"id\"]")
    private List<String> attachment;


    /*工作内容*/
    /**
     * 内容
     * 内容字数有上限3000个字，上限可设置。
     */
    @NotNull
    @ApiModelProperty(value = "内容", example = "内容...............", notes = "内容字数有上限3000个字，上限可设置.")
    private String content;


    /**
     * 工作量
     */
    @NotNull
    @ApiModelProperty(value = "工作量",example = "30")
    private int workload;

    /**
     * 工作状态
     * 目前有：未发布、进行中、待审核、待考评
     */
    @NotEmpty
    @NotNull
    @ApiModelProperty(value = "状态.进行中:underway、已提交:committed、已完结:finished", example = "finished")
    private String status;

    /**
     * 考评系数
     */
    @NotNull
    @ApiModelProperty(value = "考评系数",example = "0.8")
    private int workCoefficient;

    /**
     * 是否记录个人工作量
     */
    @ApiModelProperty(value = "是否记录个人工作量",example = "1.是记录0.不记录")
    private int pWorkload=1;

    /**
     * 是否记录任务工作量
     */
    @ApiModelProperty(value = "是否记录任务工作量",example = "1.是记录0.不记录")
    private int workloadCount=1;


}
