package com.zjty.tynotes.attendance.controller;

/**
 * @Author gwj
 * @create 2020/3/24 13:36
 */

import com.zjty.tynotes.attendance.service.DingUserService;
import com.zjty.tynotes.attendance.task.MyInit;
import com.zjty.tynotes.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import org.springframework.http.ResponseEntity;

import static org.springframework.http.ResponseEntity.ok;


/**
 * @author mcj
 */
@Api(tags = "钉钉", protocols = "http")
@RestController
@RequestMapping("/attendance/user")
@AutoDocument
public class DingUserController {
    private static final Logger logger = LoggerFactory.getLogger(DingUserController.class);
    @Autowired
    private DingUserService dingUserService;
    @Autowired
    private MyInit init;

    @GetMapping("/getToken")
    @ApiOperation(value = "手动获取钉钉token的接口")
    public ResponseEntity getToken(){
        try {
            init.getToken();
            return ok("重新获取token成功");
        } catch (Exception e) {
            logger.error("获取token失败");
        }
        return ok("重新获取token失败");
    }

    @GetMapping("/getDingUser")
    @ApiOperation(value = "手动获取钉钉的用户与本地用户进行绑定")
    public ResponseEntity getDingUser(){
        try {
            dingUserService.initDingUser();
            return ok("用户绑定成功");
        } catch (Exception e) {
            logger.error("用户绑定失败");
        }
        return ok("用户绑定失败");
    }



}
