package com.zjty.tynotes.pas.service;

import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import io.swagger.annotations.ApiModel;

import java.util.List;

/**
 * @author mcj
 */
@ApiModel(value = "用户", description = "用户管理说明")
public interface IUserService {


    /**
     * 更新用户信息
     * @param user 用户对象
     */
    User updateUser(User user);

    /**
     * 根据用户id删除用户
     * @param username 用户名
     */
    boolean deleteUserById(String username);

    /**
     * 注册用户
     * @param user user object
     * @return User
     */
    User registerUser(User user);

    /**
     * 根据用户名查询用户
     * @param username 用户名
     * @return @see User
     */
    User findUserByUsername(String username);

    /**
     * 根据姓名查询用户
     * @param name 姓名
     * @return @see User
     */
    List<User> findUserByName(String name);

    /**
     * 根据用户id查询用户
     * @param id  id
     * @return user object
     */
    User findUserById(String id);

    /**
     * 根据用户id查询用户
     * @param ids  id集合
     * @return user list
     */
    List<User> findUserByIds(List<String> ids);

    /**
     * 查询所有用户
     * @return List<User>
     */
    List<User> findAll();

    /**
     * 记录+1
     * @param username 用户名
     * @return 还有几次登陆机会
     */
    String addUserCount(String username);

    /**
     * 新增用户
     * @param user
     * @return
     */
    User addUser(User user);

    /**
     * 根据用户id判断是否有某个权限
     * @param userId
     * @param authorityName
     * @return
     */
    boolean isHaveAuthority(String userId,String authorityName);

    /**
     * 查询上级管理人员集合
     * @param userId
     * @return
     */
    List<User> findParentManager(String userId);

    /**
     * 根据人员id查询可发布任务的人员
     * @param userId
     * @return
     */
    List<User> findUserList(String userId,String authoryName);

    /**
     * 供任务模块调用，根据人员id查询该人员能看到任务的所有人员.
     * @param userId
     * @return
     */
    List<String> findUsers(String userId);

    /**
     * 对密码加密(测试数据时用到的接口，目前不要用)
     * @return
     */
    Object encryPas();


    /**
     * 删除root用户(不要使用)
     * @return
     */
    Object deleteRoot();


    /**
     * 返回所有上级部门id
     * @param departmentId
     * @return
     */
    String getDepartmentLevel(String departmentId);

    /**
     * 查询上级部门等级
     * @param departmentId
     * @return
     */
    String getParentDepartmentLevel(String departmentId);

    /**
     * 根据用户id判断某个用户是否有该部门的审批权限
     * @param userId
     * @param departmentId
     * @return
     */
    boolean findUsersByDepartmentAndAuthority(String userId, String departmentId);

    /**
     * 重置密码
     * @param id
     * @return
     */
    boolean replacePass(String id);

    /**
     * 判断是否为上级，并且拥有修改任务权限
     * @param id
     * @param userId
     * @return
     */
    boolean judgeParent(String id, String userId);
}
