package com.zjty.tynotes.search.subject.service;

import com.zjty.tynotes.search.subject.entity.CollectionRs;
import com.zjty.tynotes.search.subject.entity.EsSearchArg;
import com.zjty.tynotes.search.subject.entity.EsSource;

import java.util.List;
import java.util.Map;

/**
 * @author LJJ
 * on 2019-04-24
 */
public interface EsUtil {

    /**
     * create index in es
     * use this method when create user
     * <p>
     * create index name
     *
     * @param indexName string
     */
    void createIndex(String indexName);

    /**
     * save one data to es
     *
     * @param indexName people id
     * @param data      source
     *                  id is task id
     * @return if success return true, else return false
     */
    boolean save(String indexName, EsSource data);

    /**
     * bulk save data
     *
     * @param indexName index name
     * @param data      list of dataa
     * @return if success return true, else return false
     */
    boolean save(String indexName, List<EsSource> data);

    /**
     * search task's method
     *
     * @param indexName   index name
     * @param esSearchArg some of args for searching
     * @return list of es's id
     */
    List<Map<String, Object>> search(String indexName, EsSearchArg esSearchArg);

    /**
     * 搜索代办事项的方法
     *
     * @param id          索引名称（人员id）
     * @param esSearchArg 搜索参数
     * @return list
     */
    CollectionRs getPresentTask(String id, EsSearchArg esSearchArg);

    /**
     * 搜索我的任务列表
     */

    CollectionRs getMeTask(String id, EsSearchArg esSearchArg);
    /**
     * 搜索我的接收任务
     */
    CollectionRs getMeReceiveTask(String id, EsSearchArg esSearchArg);
    /**
     * 搜索我的分解任务
     */
    CollectionRs getMeResolveTask(String id, EsSearchArg esSearchArg);
    /**
     * 搜索我的发布的任务
     */
    CollectionRs getMeReleaseTask(String id, EsSearchArg esSearchArg);
    /**
     * 搜索已提交任务的方法
     *
     * @param id          索引名称（人员id）
     * @param esSearchArg 搜索参数
     * @return list
     */
    CollectionRs getApplyTask(String id, EsSearchArg esSearchArg);

    /**
     * 搜索相关任务，不包括已完结任务
     *
     * @param id          索引名称（人员id）
     * @param esSearchArg 搜索参数
     * @return list
     */
    CollectionRs getContactTask(String id, EsSearchArg esSearchArg);

    /**
     * 搜索收藏任务
     *
     * @param id   索引名称
     * @param page 页数，从0开始
     * @param size 每页大小
     * @return list
     */
    CollectionRs getCollection(String id, int page, int size);

    /**
     * 根据标题搜索
     *
     * @param id    索引名称
     * @param title 标题
     * @param page  页数
     * @param size  每页大小
     * @return list
     */
    CollectionRs getTaskByTitle(String id, String title, int page, int size);

    /**
     * find by ids
     *
     * @param indexName index name (people id)
     * @return list
     */
    List<Map<String, Object>> findByIds(String indexName);

    /**
     * find one people's task info
     *
     * @param indexName index name (people id)
     * @param id        task id
     * @return task info
     */
    Map<String, Object> findOne(String indexName, String id);

    /**
     * delete data by index name and task id
     *
     * @param indexName index name
     * @param id        task id
     */
    void delete(String indexName, String id);

    /**
     * get es's total num
     *
     * @param indexName index name
     * @return long
     */
    long getTotal(String indexName);

}
