package com.zjty.tynotes.address.server.controller;

import com.zjty.tynotes.address.server.entity.Notice;
import com.zjty.tynotes.address.server.service.NoticeService;
import com.zjty.tynotes.misc.config.AutoDocument;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @Author gwj
 * @create 2020/5/13 14:30
 */
@Api(tags = "通知模块", protocols = "http")
@RestController
@RequestMapping("/notice/manage")
@AutoDocument
public class NoticeController {

    private static final Logger logger = LoggerFactory.getLogger(NoticeController.class);

    @Autowired
    private NoticeService noticeService;

    @ApiOperation(value = "根据人的id查找所有相同部门")
    @GetMapping("/findUserByLevel/{id}")
    public ResponseEntity findUserByLevel(@PathVariable String id) {
        List<Department> departments = noticeService.findDepart(id);
        if(departments!=null){
            return ok(departments);
        }
        return ok("根据部门等级查找所有部门");
    }

    @ApiOperation(value = "回应通知")
    @PostMapping("/replyNotice")
    public ResponseEntity replyNotice(@RequestBody Notice notice) {
        Notice notice1 = noticeService.replyNotice(notice);
        if(notice1!=null){
            return ok(notice1);
        }
        return ok("回应通知失败");
    }

    @ApiOperation(value = "获取某部门下的所有人员")
    @GetMapping("/findUnderUser/{departId}")
    public ResponseEntity findUnderUser(@PathVariable String departId) {
        List<User> userList = noticeService.findUnderUser(departId);
        if(userList!=null){
            return ok(userList);
        }
        return ok("回应通知失败");
    }

    @ApiOperation(value = "查询所有我未处理的通知")
    @GetMapping("/findNotReadNotice/{id}")
    public ResponseEntity findNotReadNotice(@PathVariable String id) {
        try {
            List<Notice> notReadNotice = noticeService.findNotReadNotice(id);
            return ok(notReadNotice);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ok("查询所有我未处理的通知失败");
    }

    @ApiOperation(value = "查询所有我请求的通知")
    @GetMapping("/findReadNotice/{id}")
    public ResponseEntity findReadNotice(@PathVariable String id) {
        try {
            List<Notice> notices = noticeService.findReadNotice(id);
            return ok(notices);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ok("查询所有我请求的通知失败");
    }
}
