package com.zjty.tynotes.weekly.subject.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.zjty.tynotes.pas.entity.Role;
import com.zjty.tynotes.pas.entity.User;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/3 10:03
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserVo {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "身份证号码不可为空")
    @ApiModelProperty(value = "身份证",example = "48489498131566546")
    private String idCard;

    @NotEmpty(message = "地址不可为空")
    @ApiModelProperty(value = "地址",example = "xx路xx楼xx号")
    private String address;

    @NotEmpty(message = "联系方式不可为空")
    @ApiModelProperty(value = "联系方式",example = "113665465465")
    private String phone1;

    @NotEmpty(message = "联系方式不可为空")
    @ApiModelProperty(value = "联系方式",example = "113665465465")
    private String phone2;

    @ApiModelProperty(value = "部门1",example = "研发部")
    private String department1;

    @ApiModelProperty(value = "部门2",example = "技术中心")
    private String department2;

    @ApiModelProperty(value = "部门3",example = "工作簿项目组")
    private String department3;

    @NotNull(message = "岗位不可为空")
    @ApiModelProperty(value = "岗位",example = "1")
    private String jobs;

    @NotNull(message = "入职时间不可为空")
    @ApiModelProperty(value = "入职时间",example = "2019-01-45 12:12:12")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private String entryTime;

    @NotEmpty(message = "邮箱不可为空")
    @ApiModelProperty(value = "邮箱",example = "123456789@qq.com")
    private String email;

    @NotEmpty(message = "用户名不可为空")
    @ApiModelProperty(value = "用户名",example = "username")
    private String username;
    @NotEmpty(message = "密码不可为空")
    @ApiModelProperty(value = "密码",example = "password")
    private String password;

    @NotEmpty(message = "部门id集合")
    @ApiModelProperty(value = "部门id集合",example = "1")
    private List<String> departmentIds;

    private List<Role> roles;

    private String status;//工作状态(0代表空闲  1代表忙碌)

    private Integer workCount;

//    @NotNull(message = "角色Id不可为空")
//    @ApiModelProperty(value = "角色id",example = "1")
//    private Integer roleId;


    public UserVo(User user) {
        this.id = user.getId();
        this.idCard = user.getIdCard();
        this.address = user.getAddress();
        this.phone1 = user.getPhone1();
        this.phone2 = user.getPhone2();
        this.department1 = user.getDepartment1();
        this.department2 = user.getDepartment2();
        this.department3 = user.getDepartment3();
        this.jobs = user.getJobs();
        this.entryTime = user.getEntryTime();
        this.email = user.getEmail();
        this.username = user.getUsername();
        this.password = user.getPassword();
        this.departmentIds = user.getDepartmentIds();
        this.roles = new ArrayList<>();
        this.status = user.getStatus();
        this.workCount = user.getWorkNum();
        this.roles = user.getRoles();
    }
}
