package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.validation.constraints.NotEmpty;

/**
 * @des 关联表，本地用户id与钉钉用户id关联
 * @Author gwj
 * @create 2020/3/24 9:21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "用户关联", description = "用户关联")
@Document(collection = "ding_user")
public class DingUser {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    private String id;

    @NotEmpty(message = "用户id")
    @ApiModelProperty(value = "用户id",example = "eqsd12314rrqsad1233")
    private String userId;

    @NotEmpty(message = "钉钉用户id")
    @ApiModelProperty(value = "钉钉用户id",example = "1111212112")
    private String dingUserId;


}
