package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/24 14:07
 */
@Data
@AllArgsConstructor
@ApiModel(value = "个人考勤信息", description = "个人考勤信息")
@Document(collection = "ding_attendance")
public class AttendanceDetails {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    String id;

    @ApiModelProperty(value = "用户id",example = "eqweqw12312e")
    String userId;

//    @ApiModelProperty(value = "平均工时",example = "176")
//    Integer averageWorkHours;
//
//    @ApiModelProperty(value = "应出勤天数",example = "22")
//    Integer attendanceDay;
//
//    @ApiModelProperty(value = "实际出勤天数",example = "22")
//    Integer realAttendanceDay;

    @ApiModelProperty(value = "是否出勤0为出勤/1为未出勤",example = "22")
    Integer isRealAttendanceDay;

    @ApiModelProperty(value = "是否迟到0为迟到/1为未迟到",example = "1")
    Integer isLateDay;

    @ApiModelProperty(value = "迟到等级0轻(15分钟以内)/1较轻(1小时以内)/2较严重(4小时以内)/3严重(4小时以上)",example = "1")
    Integer lateStatus;

    @ApiModelProperty(value = "是否早退0为早退/1为未早退",example = "1")
    Integer isLeaveEarlyDay;

    @ApiModelProperty(value = "早退等级0轻/1较轻/2较严重/3严重",example = "1")
    Integer earlyStatus;

    @ApiModelProperty(value = "缺卡次数",example = "2")
    Integer lessCard;

    @ApiModelProperty(value = "是否旷工0为旷工/1为未旷工",example = "2")
    Integer isAbsenteeismDay;

    @ApiModelProperty(value = "旷工天数",example = "2")
    Float absenteeismDay;

    @ApiModelProperty(value = "是否加班0为加班/1为未加班",example = "10")
    Integer isWorkOverHours;

    @ApiModelProperty(value = "加班时长",example = "4")
    Integer workOverHours;

    @ApiModelProperty(value = "是否调休0为调休/1为未调休",example = "1")
    Integer isPaidLeaveDay;

    @ApiModelProperty(value = "调休时长",example = "1")
    Float paidLeaveDay;

    @ApiModelProperty(value = "是否事假0为事假/1为未事假",example = "1")
    Integer isThingLeaveDay;

    @ApiModelProperty(value = "事假天数",example = "1")
    Float thingLeaveDay;

    @ApiModelProperty(value = "是否病假0为病假/1为未病假",example = "1")
    Integer isSickLeaveDay;

    @ApiModelProperty(value = "病假时长",example = "1")
    Float sickLeaveDay;

    @ApiModelProperty(value = "是否公出",example = "1")
    Integer isOutSideBusinessDay;

    @ApiModelProperty(value = "公出天数",example = "1")
    Float outSideBusinessDay;

    @ApiModelProperty(value = "出差",example = "1")
    Integer isOutWorkDay;

    @ApiModelProperty(value = "出差时长",example = "1")
    Float outWorkDay;

    @ApiModelProperty(value = "时间",example = "2020-03-22 09:00:00")
    Date attenDate;

    public AttendanceDetails() {
        thingLeaveDay = 0f;
        paidLeaveDay = 0f;
        workOverHours = 0;
        outSideBusinessDay = 0f;
        outWorkDay = 0f;
        sickLeaveDay = 0f;
        absenteeismDay = 0f;
    }
}
