package com.zjty.tynotes.job.basic.repository;

import com.zjty.tynotes.job.basic.entity.database.Work;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * <p>Description : note
 * <p>Date : 2019/4/23 9:45
 * <p>@author : C
 */
@Repository
public interface WorkRepository extends MongoRepository<Work, String> {
    /**
     *   上级任务id查询所有子任务
     * @param superiorId 任务id
     * @return 任务集合
     */
    List<Work> findBySuperiorId(String superiorId);

    /**
     * 根据执行者id查询所有的任务
     * @param ids 用户id集合
     * @return
     */
    List<Work> findAllByExecutorIn(List<String> ids);


    List<Work> findByAuditTimeBefore(Date auditTime);

    /**
     * 根据人员id以及时间范围查询开始时间在范围里的任务
     * @param id 人员id
     * @param sTime 开始时间
     * @param eTime 结束时间
     * @return 集合
     */
    List<Work> findByExecutorAndStateTimeBetween(String id,Date sTime,Date eTime);

    /**
     * 根据人员id以及的任务
     * @param id 人员id
     * @return 集合
     */
    List<Work> findByExecutor(String id);

    /**
     * 根据人员id以及任务状态查询相关的任务
     * @param id 人员id
     * @param status 状态
     * @return 任务集合
     */
    List<Work> findByExecutorAndStatus(String id,String status);
}
