package com.zjty.tynotes.attendance.service.impl;

import com.zjty.tynotes.attendance.dao.ApprovalInformationDao;
import com.zjty.tynotes.attendance.dao.AttendanceDetailsDao;
import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import com.zjty.tynotes.attendance.service.ApprovalInformationService;
import com.zjty.tynotes.pas.dao.DepartmentDao;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @Author gwj
 * @create 2020/3/24 15:23
 */
@Service
public class ApprovalInformationServiceImpl implements ApprovalInformationService {
    @Autowired
    private ApprovalInformationDao approvalInformationDao;
    @Autowired
    private AttendanceDetailsDao attendanceDetailsDao;
    @Autowired
    private IUserService iUserService;
    @Autowired
    private DepartmentDao departmentDao;

    @Override
    public ApprovalInformation addApproval(ApprovalInformation approvalInformation) {

        if(approvalInformation.getApprovalType().equals("调休")){
            String userId = approvalInformation.getUserId();
            AttendanceDetails attendanceDetails = attendanceDetailsDao.findByUserId(userId);
            Integer workOverHours = attendanceDetails.getWorkOverHours();
            Date leaveEndTime = approvalInformation.getLeaveEndTime();
            Date leaveStartTime = approvalInformation.getLeaveStartTime();
            long l = leaveEndTime.getTime() - leaveStartTime.getTime();
            long daytime = 24*60*60*1000;
            long day;
            if(l%daytime==0){
                day = l/daytime;
            }else{
                day = l/daytime + 1;
            }
            if(workOverHours<=(day*8)){
                return null;
            }
            if(day>2){
                approvalInformation.setApprovalLevel("1");
            }else{
                approvalInformation.setApprovalLevel("2");
            }

        }
        approvalInformation.setStatus("待审批");
        return approvalInformationDao.save(approvalInformation);
    }

    @Override
    public boolean deleteApproval(String id) {
        Optional<ApprovalInformation> optional = approvalInformationDao.findById(id);
        if(optional.isPresent()){
            ApprovalInformation approvalInformation = optional.get();
            String status = approvalInformation.getStatus();
            if(("0").equals(status)){
                approvalInformationDao.deleteById(id);
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public ApprovalInformation auditApproval(String userId,String approvalStatus,ApprovalInformation approvalInformation) {
        String departmentId = approvalInformation.getDepartmentId();
        String departmentLevel = iUserService.getDepartmentLevel(departmentId);
        if(("1").equals(departmentLevel)||("2").equals(departmentLevel)){
            approvalInformation.setApprovalUserIdOne(userId);
            if(approvalInformation.getApprovalStatus()!=null && approvalInformation.getApprovalStatus().equals("0")){
                approvalInformation.setStatus("1");
                approvalInformation.setApprovalOne("0");
            }else if(approvalInformation.getApprovalStatus()!=null && approvalInformation.getApprovalStatus().equals("1")){
                approvalInformation.setStatus("2");
                approvalInformation.setApprovalOne("1");
            }
        }else {
            if(approvalInformation.getApprovalTwo()==null){
                approvalInformation.setApprovalUserIdTwo(userId);
                if(approvalInformation.getApprovalStatus()!=null && approvalInformation.getApprovalStatus().equals("0")){
                    approvalInformation.setApprovalTwo("0");
                }else if(approvalInformation.getApprovalStatus()!=null && approvalInformation.getApprovalStatus().equals("1")){
                    approvalInformation.setStatus("2");
                    approvalInformation.setApprovalTwo("1");
                }
            }else if(approvalInformation.getApprovalTwo()!=null && approvalInformation.getApprovalOne()==null){
                String parentDepartmentLevel = iUserService.getParentDepartmentLevel(departmentId);
                if(("1").equals(parentDepartmentLevel)||("2").equals(parentDepartmentLevel)){
                    approvalInformation.setApprovalUserIdOne(userId);
                    if(approvalInformation.getApprovalStatus()!=null && approvalInformation.getApprovalStatus().equals("0")){
                        approvalInformation.setStatus("1");
                        approvalInformation.setApprovalOne("0");
                    }else if(approvalInformation.getApprovalStatus()!=null && approvalInformation.getApprovalStatus().equals("1")){
                        approvalInformation.setStatus("2");
                        approvalInformation.setApprovalOne("1");
                    }
                }
            }
        }
        return approvalInformation;
    }


    @Override
    public List<ApprovalInformation> findAllApproval(String userId) {
        return approvalInformationDao.findAllByUserId(userId);
    }

    @Override
    public List<ApprovalInformation> findAllAuditApproval(String userId) {
        List<String> statusList = new ArrayList<>();
        List<String> strings = new ArrayList<>();
        statusList.add("1");
        statusList.add("2");
        List<ApprovalInformation> approvalInformations = approvalInformationDao.findAllByStatusIn(statusList);
        List<ApprovalInformation> approvalInformationList = new ArrayList<>();
        approvalInformations.forEach(approvalInformation -> {
            if(userId.equals(approvalInformation.getApprovalUserIdOne())){
                approvalInformationList.add(approvalInformation);
            }else if(userId.equals(approvalInformation.getApprovalUserIdTwo())){
                approvalInformationList.add(approvalInformation);
            }
        });
        strings.add("0");
        List<ApprovalInformation> approvalInformationList1 = approvalInformationDao.findAllByStatusIn(strings);
        approvalInformationList1.forEach(approvalInformation -> {
            String departmentId = approvalInformation.getDepartmentId();
            String departmentLevel = iUserService.getDepartmentLevel(departmentId);
            if(("1").equals(departmentLevel)||("2").equals(departmentLevel)){
                boolean flag = iUserService.findUsersByDepartmentAndAuthority(userId,departmentId);
                if(flag){
                    approvalInformationList.add(approvalInformation);
                }
            }else{
                if(approvalInformation.getApprovalTwo()==null&&approvalInformation.getApprovalOne()==null){
                    boolean flag = iUserService.findUsersByDepartmentAndAuthority(userId,departmentId);
                    if(flag){
                        approvalInformationList.add(approvalInformation);
                    }
                }else if (approvalInformation.getApprovalTwo()!=null && approvalInformation.getApprovalOne()==null){
                    Optional<Department> optional = departmentDao.findById(departmentId);
                    if(optional.isPresent()){
                        Department department = optional.get();
                        String parentId = department.getParentId();
                        boolean flag = iUserService.findUsersByDepartmentAndAuthority(userId,parentId);
                        if(flag){
                            approvalInformationList.add(approvalInformation);
                        }
                    }
                }
            }

        });
        return approvalInformationList;
    }
}
