package com.zjty.tynotes.attendance.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;

/**
 * @Author gwj
 * @create 2020/3/24 14:07
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "个人考勤信息", description = "个人考勤信息")
@Document(collection = "ding_attendance")
public class AttendanceDetails {
    @Id
    @ApiModelProperty(value = "id",example = "1")
    String id;

    @ApiModelProperty(value = "用户id",example = "eqweqw12312e")
    String userId;

    @ApiModelProperty(value = "平均工时",example = "176")
    Integer averageWorkHours;

    @ApiModelProperty(value = "应出勤天数",example = "22")
    Integer attendanceDay;

    @ApiModelProperty(value = "实际出勤天数",example = "22")
    Integer realAttendanceDay;

    @ApiModelProperty(value = "迟到天数",example = "1")
    Integer lateDay;

    @ApiModelProperty(value = "早退天数",example = "1")
    Integer leaveEarlyDay;

    @ApiModelProperty(value = "缺卡次数",example = "2")
    Integer lessCard;

    @ApiModelProperty(value = "旷工天数",example = "2")
    Integer absenteeismDay;

    @ApiModelProperty(value = "加班时长",example = "10")
    Integer workOverHours;

    @ApiModelProperty(value = "调休天数",example = "1")
    Float paidLeaveDay;

    @ApiModelProperty(value = "病假天数",example = "1")
    Float sickLeaveDay;

    @ApiModelProperty(value = "公出天数",example = "1")
    Float outSideBusinessDay;

    @ApiModelProperty(value = "时间,只需要精确到月份",example = "2020-03")
    Date date;
}
