package com.zjty.tynotes.attendance.service.impl;

import com.zjty.tynotes.attendance.dao.ApprovalInformationDao;
import com.zjty.tynotes.attendance.dao.AttendanceDetailsDao;
import com.zjty.tynotes.attendance.entity.ApprovalInformation;
import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import com.zjty.tynotes.attendance.service.ApprovalInformationService;
import com.zjty.tynotes.pas.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @Author gwj
 * @create 2020/3/24 15:23
 */
@Service
public class ApprovalInformationServiceImpl implements ApprovalInformationService {
    @Autowired
    private ApprovalInformationDao approvalInformationDao;
    @Autowired
    private AttendanceDetailsDao attendanceDetailsDao;
    @Autowired
    private IUserService iUserService;

    @Override
    public ApprovalInformation addApproval(ApprovalInformation approvalInformation) {

        if(approvalInformation.getApprovalType().equals("调休")){
            String userId = approvalInformation.getUserId();
            AttendanceDetails attendanceDetails = attendanceDetailsDao.findByUserId(userId);
            Integer workOverHours = attendanceDetails.getWorkOverHours();
            Date leaveEndTime = approvalInformation.getLeaveEndTime();
            Date leaveStartTime = approvalInformation.getLeaveStartTime();
            long l = leaveEndTime.getTime() - leaveStartTime.getTime();
            long daytime = 24*60*60*1000;
            long day;
            if(l%daytime==0){
                day = l/daytime;
            }else{
                day = l/daytime + 1;
            }
            if(workOverHours<=(day*8)){
                return null;
            }
            if(day>2){
                approvalInformation.setApprovalLevel("1");
            }else{
                approvalInformation.setApprovalLevel("2");
            }

        }
        approvalInformation.setStatus("待审批");
        return approvalInformationDao.save(approvalInformation);
    }

    @Override
    public boolean deleteApproval(String id) {
        Optional<ApprovalInformation> optional = approvalInformationDao.findById(id);
        if(optional.isPresent()){
            ApprovalInformation approvalInformation = optional.get();
            String status = approvalInformation.getStatus();
            if(("0").equals(status)){
                approvalInformationDao.deleteById(id);
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public ApprovalInformation auditApproval(String userId,String id, String approvalStatus) {
        Optional<ApprovalInformation> optional = approvalInformationDao.findById(id);
        ApprovalInformation approvalInformation = null;
        if(optional.isPresent()){
            approvalInformation = optional.get();
            List<String> departmentLevels = iUserService.getDepartmentLevel(approvalInformation.getUserId(), userId);
            if(departmentLevels.contains("2")||departmentLevels.contains("1")){
                approvalInformation.setApprovalStatus(approvalStatus);
                if(approvalStatus.equals("0")){
                    approvalInformation.setApprovalUserIdOne(userId);
                    approvalInformation.setStatus("1");
                    approvalInformation.setApprovalOne("0");
                }else{
                    approvalInformation.setApprovalUserIdOne(userId);
                    approvalInformation.setStatus("2");
                    approvalInformation.setApprovalOne("1");
                }
            }else if(departmentLevels.contains("3")){
                if(approvalStatus.equals("0")){
                    approvalInformation.setApprovalUserIdTwo(userId);
                    approvalInformation.setApprovalTwo("0");
                }else{
                    approvalInformation.setApprovalUserIdTwo(userId);
                    approvalInformation.setStatus("1");
                    approvalInformation.setApprovalTwo("1");
                }
            }
        }
        return approvalInformation;
    }

    @Override
    public List<ApprovalInformation> findAllApproval(String userId) {
        return approvalInformationDao.findAllByUserId(userId);
    }

    @Override
    public List<ApprovalInformation> findAllAuditApproval(String userId) {
        return approvalInformationDao.findAllByApprovalUserIdOneOrApprovalUserIdTwo(userId);
    }
}
