package com.zjty.tynotes.weekly.subject.service;

import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.entity.vo.PageRequest;
import com.zjty.tynotes.pas.entity.vo.PageResponse;
import com.zjty.tynotes.weekly.subject.entity.vo.Problem;
import com.zjty.tynotes.weekly.subject.entity.vo.UserVo;

import java.text.ParseException;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/2 13:07
 */
public interface UserManageService {
    /**
     * 根据id查询用户
     * @param id
     * @return
     */
    User findUserById(String id);

    /**
     * 分页查询管理用户
     * @param pageRequest
     * @return
     */
    PageResponse<UserVo> findUserList(PageRequest pageRequest) throws ParseException;

    /**
     * 根据用户id查询可管理的部门列表
     * @param id
     * @return
     */
    List<Department> findDepartmentList(String id);

    /**
     * 更改密码
     * @param user
     * @return
     */
    boolean updatePas(User user);

    /**
     * 根据用户名查询用户
     * @param username
     * @return
     */
    User findfindUserByUsername(String username);

    /**
     * 修改用户自身信息
     * @param userById
     * @return
     */
    User updateSelf(User user,User userById);

    /**
     *
     * 上传bug
     * @param problem
     * @return
     */
    Problem submitProblem(Problem problem);

    /**
     * 查找建议bug
     * @return
     */
    List<Problem> searchProblem();

    /**
     * 修改建议
     * @param problem
     * @return
     */
    Problem putProblem(Problem problem);

//    /**
//     * 根据任务状态查询人员任务列表
//     * @param id
//     * @param status
//     * @return
//     */
//    List<Work> findUserWork(String id, String status);
}
