package com.zjty.tynotes.attendance.dao;

import com.zjty.tynotes.attendance.entity.AttendanceDetails;
import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/24 14:55
 */
public interface AttendanceDetailsDao extends MongoRepository<AttendanceDetails,String> {
    AttendanceDetails findByUserId(String userId);

    AttendanceDetails findByUserIdAndDate(String userId,Date date);

    List<AttendanceDetails> findAllByUserIdAndDateBetween(String userId,Date startDate,Date endDate);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsThingLeaveDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsSickLeaveDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsLateDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsLeaveEarlyDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsOutSideBusinessDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsOutWorkDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsAbsenteeismDay(String userId,Date startDate,Date endDate,String type);

    List<AttendanceDetails> findAllByUserIdAndDateBetweenAndIsPaidLeaveDay(String userId,Date startDate,Date endDate,String type);
}
