package com.dingtalk.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP DingTalk-API: dingtalk.oapi.collection.form.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class OapiCollectionFormGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6193125975836888188L;

	/** 
	 * 错误码
	 */
	@ApiField("errcode")
	private Long errcode;

	/** 
	 * 错误信息
	 */
	@ApiField("errmsg")
	private String errmsg;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private PageResult result;


	public void setErrcode(Long errcode) {
		this.errcode = errcode;
	}
	public Long getErrcode( ) {
		return this.errcode;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}
	public String getErrmsg( ) {
		return this.errmsg;
	}

	public void setResult(PageResult result) {
		this.result = result;
	}
	public PageResult getResult( ) {
		return this.result;
	}

	public boolean isSuccess() {
        return getErrcode() == null || getErrcode().equals(0L);
    }
	
	/**
	 * 发送范围
	 *
	 * @author top auto create
	 * @since 1.0, null
	 */
	public static class ProcessVisibleValueVo extends TaobaoObject {
		private static final long serialVersionUID = 4289467254825359981L;
		/**
		 * 可见性类型 0部门 1人员 2角色 3群组cid
		 */
		@ApiField("type")
		private Long type;
		/**
		 * 值
		 */
		@ApiField("value")
		private String value;
	
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}
		public String getValue() {
			return this.value;
		}
		public void setValue(String value) {
			this.value = value;
		}
	}
	
	/**
	 * 结果
	 *
	 * @author top auto create
	 * @since 1.0, null
	 */
	public static class PageResult extends TaobaoObject {
		private static final long serialVersionUID = 2543189717151576765L;
		/**
		 * schema
		 */
		@ApiField("content")
		private String content;
		/**
		 * 应参与人数
		 */
		@ApiField("should_participation_cnt")
		private Long shouldParticipationCnt;
		/**
		 * 发送范围
		 */
		@ApiListField("visible_list")
		@ApiField("process_visible_value_vo")
		private List<ProcessVisibleValueVo> visibleList;
	
		public String getContent() {
			return this.content;
		}
		public void setContent(String content) {
			this.content = content;
		}
		public Long getShouldParticipationCnt() {
			return this.shouldParticipationCnt;
		}
		public void setShouldParticipationCnt(Long shouldParticipationCnt) {
			this.shouldParticipationCnt = shouldParticipationCnt;
		}
		public List<ProcessVisibleValueVo> getVisibleList() {
			return this.visibleList;
		}
		public void setVisibleList(List<ProcessVisibleValueVo> visibleList) {
			this.visibleList = visibleList;
		}
	}
	


}
