package com.dingtalk.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP DingTalk-API: dingtalk.oapi.smartapp.form.instance.add response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class OapiSmartappFormInstanceAddResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2688351295187385764L;

	/** 
	 * 错误码
	 */
	@ApiField("errcode")
	private Long errcode;

	/** 
	 * 错误信息
	 */
	@ApiField("errmsg")
	private String errmsg;

	/** 
	 * 导入错误信息
	 */
	@ApiListField("result")
	@ApiField("form_instance_write_error_vo")
	private List<FormInstanceWriteErrorVo> result;

	/** 
	 * 执行结果
	 */
	@ApiField("success")
	private Boolean success;


	public void setErrcode(Long errcode) {
		this.errcode = errcode;
	}
	public Long getErrcode( ) {
		return this.errcode;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}
	public String getErrmsg( ) {
		return this.errmsg;
	}

	public void setResult(List<FormInstanceWriteErrorVo> result) {
		this.result = result;
	}
	public List<FormInstanceWriteErrorVo> getResult( ) {
		return this.result;
	}

	public void setSuccess(Boolean success) {
		this.success = success;
	}
	public Boolean getSuccess( ) {
		return this.success;
	}

	public boolean isSuccess() {
        return getErrcode() == null || getErrcode().equals(0L);
    }
	
	/**
	 * 导入错误信息
	 *
	 * @author top auto create
	 * @since 1.0, null
	 */
	public static class FormInstanceWriteErrorVo extends TaobaoObject {
		private static final long serialVersionUID = 1134479762495924533L;
		/**
		 * 发生错误的业务主键
		 */
		@ApiField("biz_id")
		private String bizId;
		/**
		 * 该数据导入的错误信息
		 */
		@ApiField("error_msg")
		private String errorMsg;
	
		public String getBizId() {
			return this.bizId;
		}
		public void setBizId(String bizId) {
			this.bizId = bizId;
		}
		public String getErrorMsg() {
			return this.errorMsg;
		}
		public void setErrorMsg(String errorMsg) {
			this.errorMsg = errorMsg;
		}
	}
	


}
