package com.zjty.tynotes.job.basic.entity.request;

import com.zjty.tynotes.job.basic.entity.database.ScoreCoefficient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "请求新增考评对象", description = "新增考评对象")
public class ScRo {
    /**
     * 编号
     */
    @ApiModelProperty(value = "编号", example = "id")
    private String id;

    /**
     * 任务id
     */
    @ApiModelProperty(value = "任务id", example = "任务id")
    private String wordId;

    /**
     * 自评分
     */
    @ApiModelProperty(value = "自评分", example = "score1")
    private String score1;

    /**
     * 自评评语
     */
    @ApiModelProperty(value = "自评评语", example = "comments1")
    private String comments1;
    /**
     * 发布者评价
     */
    @ApiModelProperty(value = "发布者评价", example = "score2")
    private String score2;
    /**
     * 发布者评语
     */
    @ApiModelProperty(value = "发布者评语", example = "comments2")
    private String comments2;
    /**
     *  最终工作量
     */
    @ApiModelProperty(value = "最终工作量", example = "endWorkLoad")
    private int endWorkLoad;

    @ApiModelProperty(value = "用户id", example = "userId")
    private String userId;

    public ScoreCoefficient toDb(){
        return new ScoreCoefficient(id,wordId,score1,comments1,score2,comments2,endWorkLoad);
    }
}
