package com.zjty.tynotes.pas.service;

import com.zjty.tynotes.pas.entity.Config;
import com.zjty.tynotes.pas.entity.Day;
import com.zjty.tynotes.pas.entity.vo.HolidayRequest;

import java.util.Date;
import java.util.List;

/**
 * @Author gwj
 * @create 2020/3/1 9:45
 */
public interface ConfigService {
    /**
     * 保存参数配置
     * @param configs
     * @return
     */
    Config save(Config configs);

    /**
     * 查找节假日
     * @param holidayRequest
     * @return
     */
    List<Date> findHolidays(HolidayRequest holidayRequest);

    /**
     * 批量设置节假日
     * @param days
     * @return
     */
    List<Day> setHolidays(List<Day> days);

    /**
     * 设置单个节假日
     * @param day
     * @return
     */
    Day setHoliday(Day day);

    /**
     * 查找某个月的节假日情况
     * @param date
     * @return
     */
    List<Day> findHolidaysByMonth(String date);

    Config findConfig();

}
