package com.zjty.tynotes.pas.service.impl;

import com.zjty.tynotes.pas.dao.DepartmentDao;
import com.zjty.tynotes.pas.dao.PasUserDao;
import com.zjty.tynotes.pas.dao.RoleDao;
import com.zjty.tynotes.pas.entity.Department;
import com.zjty.tynotes.pas.entity.Role;
import com.zjty.tynotes.pas.entity.User;
import com.zjty.tynotes.pas.service.IDepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotNull;
import java.util.*;

/**
 * @Author: mcj
 * @Date: 19-4-30 上午11:03
 * @Version 1.0
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class DepartmentServiceImpl implements IDepartmentService {

    @Autowired
    private DepartmentDao departmentDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private PasUserDao pasUserDao;

    @Override
    public List<Department> findAll() {
        return departmentDao.findAll();
    }

    @Override
    public Department addDepartments(Department department) {
        Optional<Department> optional = departmentDao.findById(department.getParentId());
        if(optional.isPresent()){
            Department department1 = optional.get();
            int level = Integer.parseInt(department1.getLevel())+1;
            department.setLevel(level+"");
        }
        return departmentDao.save(department);
    }

    @Override
    public void deleteAll() {
        departmentDao.deleteAll();
    }

    @Override
    public Department findOne(String id) {
        return departmentDao.findById(id).get();
    }

    @Override
    public List<Department> findList() {
        Department department = departmentDao.findByLevel("1");
        List<Department> departmentList = new ArrayList<>();
        departmentList.add(department);
        getDepartments(departmentList);
        return departmentList;
    }

    @Override
    public boolean deleteDepartment(String id) {
        List<Role> roles = roleDao.findAllByDepartmentId(id);
        List<User> users = pasUserDao.findAllByDepartmentId(id);
        List<Department> departments = departmentDao.findAllByParentId(id);
        if((roles==null || roles.size()==0)
                && (users==null || users.size()!=0)
                && (departments!=null || departments.size()!=0)){
            departmentDao.deleteById(id);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateDepartment(Department department) {
        Optional<Department> optional = departmentDao.findById(department.getId());
        if(optional.isPresent()){
            Department department1 = optional.get();
            department1.setDescription(department.getDescription());
            department1.setLevel(department.getLevel());
            department1.setName(department.getName());
            department1.setParentId(department.getParentId());
            departmentDao.save(department1);
            return true;
        }
        return false;
    }

    public void getDepartments(List<Department> departments) {
        for (Department department : departments) {
            List<Department> departmentList = departmentDao.findAllByParentId(department.getId());
            getDepartments(departmentList);
            department.setDepartments(departmentList);
        }
    }
}
